#!/bin/sh

if [ $SHLVL -gt 2 ] ; then
	alert --stop "Please run the Installer through the Tracker." &
	exit
fi

INSTALLDIR="/boot/home/config/bin"
APPNAME="BackOnTrack"
BOOTSCRIPTDIR="/boot/home/config/boot"
STARTKEYWORD="# -- START BackOnTrack -- DO NOT ALTER THIS LINE --"
ENDKEYWORD="# --  END  BackOnTrack -- DO NOT ALTER THIS LINE --"

RESULT=$(alert --info "$APPNAME Installer

Thank you for downloading $APPNAME. This installer will automatically compile, \
install, and configure $APPNAME for you. Do you wish to proceed with this operation?" \
"No" "Yes")

if [ $RESULT = "No" ] ; then
	exit
fi

# Find our parent directory
TOMEDIR=$(dirname $0)

cd $TOMEDIR/source
make

if [ $? -ne 0 ] ; then
	alert --stop "There was an unexpected error in the compilation process.

The source code for $APPNAME might of been altered or some other compiler error \
occurred. Try downloading a new archive and install from that. If this error occurs \
again, please contact the author.

The installer will now quit. No changes have been made to your system." &
	exit
fi

BINARY=$(find ./ -name $APPNAME)

if [ ! $BINARY ] ; then
	alert --stop "There was an unexpected error in the compilation process.

$APPNAME compiled successfully but the resultant binary could not be found. \
Try running the installer again. If this error occurs again, please contact the author.

The installer will now quit. No changes have been made to your system." &
	exit
fi

DESTINATION=$(find $INSTALLDIR -name $APPNAME)

if [ $DESTINATION ] ; then
	RESULT=$(alert --warning "A version of $APPNAME is already installed.
Do you wish to replace it?" "No" "Yes")
	if [ $RESULT = "No" ] ; then
		make clean &
		alert --info "Installation halted. No changes have been made to your system."
		exit
	fi
fi

mv -f $BINARY $INSTALLDIR
make clean &

RESULT=$(alert --info "Would you like to have $APPNAME configured to automatically start \
up and shut down?
(Requires modification to your UserBootscript and UserShutdownScript.)" "No" "Yes")

if [ $RESULT = "Yes" ] ; then
	cd $BOOTSCRIPTDIR
	
	if [ ! -e UserBootscript ] ; then
		echo '#!/bin/sh' >UserBootscript
	fi
	RESULT=$(grep -x "$STARTKEYWORD" UserBootscript)
	if [ ! $RESULT ] ; then
		cat >>UserBootscript <<EOF


$STARTKEYWORD
if [ -e $INSTALLDIR/$APPNAME ] ; then
	$INSTALLDIR/$APPNAME &
fi
$ENDKEYWORD
EOF
	fi
	
	if [ ! -e UserShutdownScript ] ; then
		echo '#!/bin/sh' >UserShutdownScript
	fi
	RESULT=$(grep -x "$STARTKEYWORD" UserShutdownScript)
	if [ ! $RESULT ] ; then
		cat >>UserShutdownScript <<EOF


$STARTKEYWORD
if [ -e $INSTALLDIR/$APPNAME ] ; then
	$INSTALLDIR/$APPNAME --quit
fi
$ENDKEYWORD
EOF
	fi
fi

RESULT=$(alert --info "Would you like $APPNAME to be run right now?" "No" "Yes")
if [ $RESULT = "Yes" ] ; then
	$INSTALLDIR/$APPNAME --quit
	$INSTALLDIR/$APPNAME &
fi

cd $TOMEDIR
cd ../

RESULT=$(alert --info "Installation complete. Would you like to view the Readme for \
$APPNAME?" "No" "Yes")

if [ $RESULT = "Yes" ] ; then
	/system/Tracker $PWD/README.html &
fi
