/******************************************************************************/
/* MIListView header file.                                                    */
/******************************************************************************/
/* This is part of the APlayer Programming Package (APPP).                    */
/* Copyright (C) 1998-1999 by The APlayer-Team.                               */
/* All rights reserved.                                                       */
/*                                                                            */
/* This source, or parts thereof, may only be used in APlayer related         */
/* software. If you want to use it elsewhere, please contact the author for a */
/* permission.                                                                */
/******************************************************************************/


#ifndef __MIListView_h
#define __MIListView_h

// PolyKit headers
#include "POS.h"

// APlayer headers
#include "ColumnListView.h"


/******************************************************************************/
/* MIListView class                                                           */
/******************************************************************************/
class MIListView : public ColumnListView
{
public:
	MIListView(BRect frame, CLVContainerView** containerView, uint32 resizingMode = B_FOLLOW_LEFT | B_FOLLOW_TOP, uint32 flags = B_WILL_DRAW | B_FRAME_EVENTS | B_NAVIGABLE,
		list_view_type type = B_SINGLE_SELECTION_LIST, bool hierarchical = false, bool horizontal = true,
		bool vertical = true, bool scrollViewCorner = true, border_style border = B_NO_BORDER, const BFont* labelFont = be_plain_font);
	virtual ~MIListView(void);

protected:
	virtual void KeyDown(const char *bytes, int32 numBytes);

	float fontHeight;
};

#endif
