/******************************************************************************/
/* APlayer Module Info list item class.                                       */
/******************************************************************************/
/* This is part of the APlayer Programming Package (APPP).                    */
/* Copyright (C) 1998-1999 by The APlayer-Team.                               */
/* All rights reserved.                                                       */
/*                                                                            */
/* This source, or parts thereof, may only be used in APlayer related         */
/* software. If you want to use it elsewhere, please contact the author for a */
/* permission.                                                                */
/******************************************************************************/


// PolyKit headers
#include "PString.h"

// APlayer headers
#include "CLVListItem.h"
#include "Colors.h"

// Needed headers
#include "MIListItem.h"


/******************************************************************************/
/* Constructor                                                                */
/******************************************************************************/
MIListItem::MIListItem(float minHeight, const PString description, const PString value) : CLVListItem(0, false, false, minHeight)
{
	columnText[0] = description;
	columnText[1] = value;
}



/******************************************************************************/
/* Destructor                                                                 */
/******************************************************************************/
MIListItem::~MIListItem(void)
{
}



/******************************************************************************/
/* ChangeColumn() will change a column string.                                */
/*                                                                            */
/* Input :  "string" is the string to want in the column.                     */
/*          "columnIndex" is the column to change.                            */
/*                                                                            */
/* Output:  True if the column was changed and false if not.                  */
/******************************************************************************/
bool MIListItem::ChangeColumn(PString string, int16 columnIndex)
{
	if (string == columnText[columnIndex])
		return (false);

	columnText[columnIndex] = string;
	return (true);
}



/******************************************************************************/
/* DrawItemColumn() is called every time a column needs to be drawn.          */
/*                                                                            */
/* Input :  "owner" is the view to draw into.                                 */
/*          "itemColumnRect" is the size of the column.                       */
/*          "columnIndex" is the column to draw.                              */
/*          "complete" indicates if it should draw every pixel.               */
/******************************************************************************/
void MIListItem::DrawItemColumn(BView *owner, BRect itemColumnRect, int32 columnIndex, bool complete)
{
	BRegion region;

	// Initialize the pen
	owner->SetLowColor(White);
	owner->SetDrawingMode(B_OP_COPY);

	if (complete)
	{
		// Draw the background color
		owner->SetHighColor(White);
		owner->FillRect(itemColumnRect);
	}

	// Draw the item
	region.Include(itemColumnRect);
	owner->ConstrainClippingRegion(&region);

	if (columnIndex >= 0)
	{
		owner->SetHighColor(Black);
		owner->DrawString(columnText[columnIndex], BPoint(itemColumnRect.left + 2.0, itemColumnRect.top + textOffset));
	}

	owner->ConstrainClippingRegion(NULL);
}



/******************************************************************************/
/* Update() is called when the width or height has changed.                   */
/*                                                                            */
/* Input :  "owner" is the owner view.                                        */
/*          "font" is the font used in the column list view.                  */
/******************************************************************************/
void MIListItem::Update(BView *owner, const BFont *font)
{
	font_height fontAttr;
	float fontHeight;

	CLVListItem::Update(owner, font);

	font->GetHeight(&fontAttr);
	fontHeight = ceil(fontAttr.ascent) + ceil(fontAttr.descent);
	textOffset = ceil(fontAttr.ascent) + (Height() - fontHeight) / 2.0;
}
