/******************************************************************************/
/* MikMod Converter language strings header file.                             */
/******************************************************************************/
/* This is part of the APlayer Programming Package (APPP).                    */
/* Copyright (C) 1998-1999 by The APlayer-Team.                               */
/* All rights reserved.                                                       */
/*                                                                            */
/* This source, or parts thereof, may only be used in APlayer related         */
/* software. If you want to use it elsewhere, please contact the author for a */
/* permission.                                                                */
/******************************************************************************/


#ifndef __MikModConverter_LangStr_h
#define __MikModConverter_LangStr_h


/******************************************************************************/
/* String resources                                                           */
/******************************************************************************/
STRINGRESOURCE_BEGIN(mikcStrings)
	STRINGRESOURCE_ITEM(IDS_MIKC_NAME, "MikModConverter")
	STRINGRESOURCE_ITEM(IDS_MIKC_DESCRIPTION, "Converts all supported MikMod formats to APlayer UniMod format. This format is almost like the original MikMod UniMod format except for a few changes.\nWritten by Thomas Neumann based on MikMod 3.1.7.\n\nThis version can convert these formats:\n\n669\nAdvance Module Format (AMF)\nDigital Sound Interface Kit (DSM)\nFarandole (FAR)\nFastTracker II (XM)\nGeneral DigiMusic (GDM)\nImago Orpheus (IMF)\nImpulseTracker (IT)\nScreamTracker 2.x (STM)\nScreamTracker 3.x (S3M)\nScreamTracker Music Interface Kit (STX)\nUltraTracker (ULT)\nUniMod (MIK)")
	STRINGRESOURCE_ITEM(IDS_MIKC_WIN_TITLE, "MikMod Converter")
	STRINGRESOURCE_ITEM(IDS_MIKC_ERR_MEMORY, "Error 1:\nOut of memory")
	STRINGRESOURCE_ITEM(IDS_MIKC_ERR_INITIALIZE, "Error 2:\nCouldn't initialize converter")
	STRINGRESOURCE_ITEM(IDS_MIKC_ERR_LOADING_HEADER, "Error 3:\nCouldn't read the module header")
	STRINGRESOURCE_ITEM(IDS_MIKC_ERR_LOADING_SAMPLEINFO, "Error 4:\nCouldn't read the sample information")
	STRINGRESOURCE_ITEM(IDS_MIKC_ERR_LOADING_TRACK, "Error 5:\nCouldn't read the track information")
	STRINGRESOURCE_ITEM(IDS_MIKC_ERR_LOADING_PATTERN, "Error 6:\nCouldn't read the pattern information")
	STRINGRESOURCE_ITEM(IDS_MIKC_ERR_CORRUPT, "Error 7:\nModule is probally corrupt")
STRINGRESOURCE_END

#endif
