//
// Philosophical Stuff,
// TowerApp Class Definition and global Stuff
//
// Copyright 1998
//
// Written by: Marco Zinn
//
// As I'm new to developing for BeOS, I know that every piece of more-or-less 
// well-documented code is highly appriciated. This game was my 'try-and-find-out'-project for BeOS.
// I just copied one of the hello-world-tutorials and hacked away. This explain some not-so-perfect
// solutions here in the code. NOTE: Never start without a concept.... a rough, at least. ;-)
// As I got the History-Window to work the way I wanted it (yesterday), I remember my idea (and
// my promise on beware) to clean up the code and to publish it. So, here it is.
// It's commented for a newcomer BeOS developer. I'm not going to explain about the window/view-
// concept or the messaging system (hey, this is not the newsletter!), and I hope you know, what
// a header file is (you just found one!)
// I'm commenting the ideas of the screen layout and the way I use messaging herein.
// Please note, that I'm far away from a perfect Be Developer, so there will be some bugs in here
// (especially, I didn't to much error-checking for wrong pointers). Although, there are some
// things that simply don't work as I want them to. Check the readme for 'known issues'.
// Commenting will be as follows:
// - I'll not comment every line!
// - You'll find the explanations for the classes (especially the windows) in the appropriate
//   header files. See Towers.c for what header includes what class (I didn't put every class in
//   it's own pair of files. Please forfive me). If you're in doubt, try TowerWindow.h
// - You'll find the explanations for the functions in the .c files, as you probably want to know,
//   _how_ the stuff is done, not _that_ it is done. ;-)
// - I left a lot of 'printf'-commands in the source (the are commented out). This is from the
//   last debugging session. Perhaps, they are useful for you when playing with the code.
//   And... the explain some parts of the code by themself.
// - When you stumble across a 'AFAIK' ('as far as I know'), I'm not sure about a specific thing.
//   That means: it's seems to be that way, but don't count on it! Try it yourself...
// - Oh. I'm german, so I hope, you get done with my 'language errors' ;-)
// 
// Finally, if you like the game, or you don't like it, or you want a special feature, or you 
// like the code, or my comments, or the fact, that I publish it, [blabla]
// drop me an eMail or a postcard and tell me, from _where_ you are. 
// You'll find my adress in the readme as well.
// Thanks, Marco


// Now for the code.

#ifndef	TOWERS_H // If you don't know that kind of stuff:
#define	TOWERS_H // it makes sure, the header is included only once

//
// Forward declaration of the Disc class (needed for the global Array Discs[]):
//
class Disc;

//
// Global Constants
//
const MAX_DISCS = 10; // Maximum Number of Discs. Thats the size of the Discs[]-Array (see below)

//
// Globale Vars:
//
int		NumberOfDiscs;		// Number of Discs currently in play (=Height of Tower when starting)
Disc	*Discs[MAX_DISCS];	// Array of Pointers to the (10) Disc Objects
Disc	*DummyDisc;			// Pointer to a special Dummy-Discs(tm). This is the space-holder on 'top' of the towers
// DummyDisc Remark: The towers that are visible on screen are Views (DiscTowerView, in fact. 
//                   see TowerWindow.h). To be precise, they are derived from BListView.
//                   Sadly for me, BListViews display a list top-down (if you don't want to 
//                   overwrite the draw()-part). In order to create a 'space' over the towers,
//                   so they all stand on a common level ground or base, I have to put 'empty'
//                   entries on top of the towers. These is the DummyDisc(tm). It's just invisble
//                   If you want to make it visible, see and change Disc::Draw()
//                   NOTE: As any BListItem (a Disc is derived from that) can occur in multiple
//                   Lists (better: BListViews) at the same time, we only need ONE DummyDisc(tm).


//
// Forwand declaration of the window classes the app needs:
//
class TowerWindow;
class ControlWindow;
class HistoryWindow;


//
// Definition of TowerApp class
//
class TowerApp : public BApplication {
	public:
		TowerApp();
		~TowerApp();

	private:
		TowerWindow		*Towers;	// see TowerWindow.h
		ControlWindow	*Controls;	// see ControlWindow.h
		HistoryWindow	*History;	// see HistoryWindow.h
		void AboutRequested();
		void MessageReceived(BMessage *message);
		void ResetGame(int NewNumberOfDiscs); // Reset to a specific number of Discs
		void ResetGame() { ResetGame(NumberOfDiscs); }; // Reset without changing the number of discs
};
 
#endif /* TOWERS_H */ 