//
// Definition of HistoryWindow Classes
//
// this belongs to the 'Tower of Benoi' Project
// Copyright 1998
//
// Written by: Marco Zinn
//

#ifndef	HISTORY_WINDOW_H
#define	HISTORY_WINDOW_H

//#include <InterfaceKit.h>
//#include <string.h>

// The HistoryWindow is currently a quite one-way window:
// It show the number if moves and the moves themselves since the last reset.
// That means it just counts and displays your moves (or the moves wbile auto-solving)
class HistoryWindow : public BWindow {
	public:
		HistoryWindow(BRect frame, const char* name);
		void Reset(); 
			// Reset the Counter to 0 and clears the list
		void AddMove(char FromTower, char ToTower, int DiscSize);
			// Adds a move to the list and increases the counter
	private:
		void ShowMoveCounter(); // Updates the MoveCounter Display

		BStringView *MoveCounter;
		BListView	*Moves;
		uint32		MoveCount;
};
 
#endif /* HISTORY_WINDOW_H */ 