/*********************************************************************
	main.cpp
	
	This file contains the main routines for the replicat shell. All
	the app really is for is to export the kitten replicant.
	
	Who		When		What
	GJW		971022	Initial coding and commenting
	GJW		971024	Made window resizable
*********************************************************************/

//	Private Headers
#include "VuKitten.h"

//	Private Prototypes
filter_result quit_filter(BMessage* ioMessage, BHandler** ioTarget, BMessageFilter* inFilter);


/*********************************************************************
	main
	Args:	<none>
	Returns:	<none>
	This is the main line of the replicat program. All we do is make
	an application, make a window, and add a kitten to the window.
	We also patch the event queue to make sure the app quits
	properly.
*********************************************************************/
void main(void)
{
	BApplication* app = new BApplication("application/x-vnd.Bastion-replicat");
	BRect theRect(75,50,475,350);
	BWindow* win = new BWindow(theRect,"Replicat",B_TITLED_WINDOW,0);
	win->AddChild(new VuKitten(BRect(0,0,400,300)));
	win->AddCommonFilter(new BMessageFilter(B_QUIT_REQUESTED,quit_filter));
	win->Show();
	app->Run();
	delete app;
}


/*********************************************************************
	quit_filter
	Args:	ioMessage - the message we have been asked to filter
			ioTarget - the handler that will receive the message
			inFilter - the messagefilter we are acting for
	Returns:	whether or not to dispatch the message
	This filter intercepts quit messages for the window and sends a
	message to the app to quit. We only have the one window, and
	according to the UI guidelines a (non-server) app without any
	open windows should close.
*********************************************************************/
filter_result quit_filter(BMessage* /*ioMessage*/, BHandler** /*ioTarget*/, BMessageFilter* /*inFilter*/)
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return B_DISPATCH_MESSAGE;
}
