#ifndef __AGLIB_H__
#define __AGLIB_H__

// common structures
#ifndef AGBUILD
#ifdef __AGBeOS__
#include "AG_beos.h"
#else
#ifdef __AGFreeBSD__
#include "AG_unix.h"
#else
#ifdef __AGQNX__
#include "AG_qnx.h"
#else
#ifdef __AGLinux__
#include "AG_unix.h"
#endif
#endif
#endif
#endif

#include "AG_structures.h"
typedef void AG_LockedQueue;
typedef void AG_Lock;
typedef void AG_ScreenDesc;
typedef void AG_Sound;
#endif
#include "AG_keys.h"


#ifdef __cplusplus
extern "C" {
#endif
void AG_Debugger(char *error);

// callback hooks...
void AG_HookSetEventMouseMove(void (*MMcb)(long,long));
void AG_HookSetEventMouseButton(void (*MBcb)(long,long,long,long));
void AG_HookSetEventKey(void (*Kcb)(long,long,long,long,long));
void AG_HookSetEventQuit(void (*Kcb)(void));
void AG_HookSetEventRedraw(void (*Rcb)(AG_RectStruct*));
void AG_HookSetEventCleanup(void (*Ccb)(void));
void AG_HookSetEventInit(void (*Icb)(void));

// locked queue stuff
AG_LockedQueue *AG_LockedQueueCreate(void);
void AG_LockedQueueDelete(AG_LockedQueue *queue);
void AG_LockedQueuePush(AG_LockedQueue *queue,void *obj);
void *AG_LockedQueuePop(AG_LockedQueue *queue);
bool AG_LockedQueueIsEmpty(AG_LockedQueue *queue);
long AG_LockedQueueCount(AG_LockedQueue *queue);

// locker stuff
AG_Lock *AG_LockCreate(void);
bool AG_LockAcquire(AG_Lock*);
void AG_LockRelease(AG_Lock*);
void AG_LockDelete(AG_Lock*);

// image file functions
long AG_ImageFileGetInfo(char *path,long *width,long *height);
long AG_ImageFileLoad(char *path,char *bits,long width,long height,long depth);

// wav file reading/deleting stuff...
AG_SoundBuffer *AG_SoundWAVLoadFile(const char *fname);
AG_SoundBuffer *AG_SoundWAVLoadFP(FILE *file);
AG_SoundBuffer *AG_SoundWAVLoadPtr(void *data);
AG_SoundBuffer *AG_SoundBufferCreate(void *buffer,long buffer_size,long sample_rate,long channel_count,long bits_per_sample);
void AG_SoundBufferDelete(AG_SoundBuffer *sb);

// sound functions
AG_Sound *AG_SoundCreateFromSoundBuffer(AG_SoundBuffer *fmt);
AG_Sound *AG_SoundCreateFromFile(const char *fname);
AG_Sound *AG_SoundCreateFromMEM(unsigned char *data,int len);
void AG_SoundDelete(AG_Sound *sound);
long AG_SoundStart(AG_Sound *sound,float vol,float pan,long once);
void AG_SoundStop(AG_Sound *sound);
bool AG_SoundIsPlaying(AG_Sound *sound);
void AG_SoundSetVolume(AG_Sound *sound,float volume);
void AG_SoundSetLooping(AG_Sound *sound,bool looping);
void AG_SoundSetSamplingRate(AG_Sound *sound,long freq);
long AG_SoundGetSamplingRate(AG_Sound *sound);

// sound file functions
AG_Sound *AG_SoundFileCreate(char *fname);
void AG_SoundFileDelete(AG_Sound *sound);
void AG_SoundFileStart(AG_Sound *sound);
void AG_SoundFileStop(AG_Sound *sound);

// creating/deleting your own streams
void *AG_SoundStreamCreate(long srate,long bits_per_sample,long channels,long (*SScb)(void *obj,void *data,long len),void *obj);
void AG_SoundStreamDelete(void *ss);

void *AG_ModMixerCreate(int nsfxchan);
void AG_ModMixerDelete(void);
bool AG_ModMixerSongPlayFile(char *fname);
bool AG_ModMixerSongPlayMEM(unsigned char *mem,int len);
void AG_ModMixerSongStop(void);
void AG_ModMixerSongVolumeSet(float volume);	// 0-255
// window/screen functions

extern AG_ScreenDesc *AG_Screen;
// this should be called _before_ creating the screen
void AG_ScreenSetMultithreaded(bool multi);

bool AG_ScreenCreate(char *title,long width,long height,long depth);
void AG_ScreenSkipEnable(bool enable);
void AG_ScreenSetTitle(const char *title);
bool AG_ScreenSetFullscreen(bool full);
bool AG_ScreenIsFullscreen(void);
long AG_ScreenSetWorkspace(long ws);
bool AG_ScreenShow(bool show);
bool AG_ScreenShowCursor(bool show);
bool AG_ScreenSetBackBuffer(void *buffer,long widthbytes);
bool AG_ScreenGetBackBuffer(AG_PixmapInfo *si);
void AG_ScreenAddModifiedRect(long l,long t,long r,long b);
void AG_ScreenReleaseBackBuffer(void);
bool AG_ScreenGetPosition(long *left,long *top);
bool AG_ScreenSetPosition(long left,long top);
void AG_ScreenClose(void);
void AG_ScreenFlip(void);
long AG_ScreenGetCursorPos(long *x,long *y);
long AG_ScreenSetCursorPos(long x,long y);
void AG_ScreenSetScale(long scale);
long AG_ScreenGetScale(void);
void AG_ScreenSetMaxFPS(long fps);

// in order for these two to work, your displa (internal) must be 8 bit...
void AG_ScreenGetColorList(AG_RGBColor *colors,long first,long count);
void AG_ScreenSetColorList(AG_RGBColor *colors,long first,long count,long blit);

// for the Pixmap functions, the data is assumed to be valid. if not, you're screwed, so make sure it is first!
//void AG_PixmapFillRect(AG_PixmapInfo *bm,AG_RectStruct *r,long c);
extern void (*AG_PixmapFillRect8)(unsigned char *sbits,long sbw,long x,long y,long w,long h,long c);
extern void (*AG_PixmapConvertRect8to8)(unsigned char *sbits,long sbw,unsigned char *dbits,long dbw,long x,long y,long w,long h,unsigned char *pal16);
extern void (*AG_PixmapConvertRect8to16)(unsigned char *sbits,long sbw,unsigned short *dbits,long dbw,long x,long y,long w,long h,unsigned short *pal16);
extern void (*AG_PixmapConvertRect8to32)(unsigned char *sbits,long sbw,unsigned long *dbits,long dbw,long x,long y,long w,long h,unsigned long *pal32);
extern void (*AG_PixmapConvertRect8to8x2)(unsigned char *sbits,long sbw,unsigned char *dbits,long dbw,long x,long y,long w,long h,unsigned char *pal16);
extern void (*AG_PixmapConvertRect8to16x2)(unsigned char *sbits,long sbw,unsigned short *dbits,long dbw,long x,long y,long w,long h,unsigned short *pal16);
extern void (*AG_PixmapConvertRect8to32x2)(unsigned char *sbits,long sbw,unsigned long *dbits,long dbw,long x,long y,long w,long h,unsigned long *pal32);
extern void (*AG_PixmapCopyRect8)(unsigned char *sbits,long sbw,unsigned char *dbits,long dbw,long sx,long sy,long dx,long dy,long w,long h);
extern void (*AG_PixmapCopyRect8MaskSource)(unsigned char *sbits,long sbw,unsigned char *dbits,long dbw,long sx,long sy,long dx,long dy,long w,long h,long sm);
void AG_PixmapCopyRectMaskDest(AG_PixmapInfo *sbm,AG_PixmapInfo *dbm,AG_RectStruct *sr,AG_RectStruct *dr);

// system functions
long AG_Alert(char *str,char *b1,char *b2,char *b3);

bool AG_DirectoryExists(char *dir);
bool AG_DirectoryMake(char *dir);
bool AG_DirectoryChange(const char *dir);

bool AG_GetAppPath(char *path);
bool AG_MakeConfigDirPath(char *name,char *fname,char *path);
bool AG_GetLocalDataPath(char *name,char *path);
bool AG_GetCDPath(char *name,char *path);

long AG_Main(int argc,char *argv[],int (*gamemain)(int,char *[]));

// time functions (could very well be inlined.)
#ifndef AG_TimeValueMS
long AG_TimeValueMS(void);
#endif
#ifndef AG_TimeSleepMS
long AG_TimeSleepMS(long ms);
#endif
#ifndef AG_TimeClock
long AG_TimeClock(void);
#endif

void AG_TimeDelayDisable(bool disable);
long AG_TimeDelayIsDisabled(void);

// thread functions...
AG_Thread AG_ThreadSpawn(long (*func)(void*),char *name,void *obj);
long AG_ThreadWait(AG_Thread);
void AG_ThreadExit(long value);

#ifdef __cplusplus
};
#endif // __cpplusplus

#endif
