//Name:		Tetris.cpp
//Author:	Brian Tietz
//Copyright 1999
//Conventions:
//	Global constants (declared with const) and #defines - begin with "c_" followed by lowercase
//		words separated by underscores.
//		(E.G., #define c_my_constant 5).
//		(E.G., const int c_my_constant = 5;).
//	Global variables - begin with "g_" followed by lowercase words separated by underscores.
//		(E.G., int g_my_global;).
//	New data types (classes, structs, typedefs, etc.) - begin with an uppercase letter followed by
//		lowercase words separated by uppercase letters.  Enumerated constants contain a prefix
//		associating them with a particular enumerated set.
//		(E.G., typedef int MyTypedef;).
//		(E.G., enum MyEnumConst {c_mec_one, c_mec_two};)
//	Private member variables - begin with "m_" followed by lowercase words separated by underscores.
//		(E.G., int m_my_member;).
//	Public or friend-accessible member variables - all lowercase words separated by underscores.
//		(E.G., int public_member;).
//	Argument and local variables - begin with a lowercase letter followed by
//		lowercase words separated by underscores.  If the name is already taken by a public member
//		variable, prefix with a_ or l_
//		(E.G., int my_local; int a_my_arg, int l_my_local).
//	Functions (member or global) - begin with an uppercase letter followed by lowercase words
//		separated by uppercase letters.
//		(E.G., void MyFunction(void);).
//License:
//  Obviously, the idea for Tetris isn't mine, so I hold no copyright on the idea.  I do, however,
//  reserve all rights with regard to the source code for this BeOS version of Tetris.  The executable,
//  is freely distributable.  The source code is likewise freely distributable, provided that the
//  license and copyright are retained in these source code files and in the about box of the
//  executable.


//******************************************************************************************************
//**** System header files
//******************************************************************************************************
#include <Alert.h>


//******************************************************************************************************
//**** Project header files
//******************************************************************************************************
#include "Tetris.h"
#include "TetrisWindow.h"
#include "AboutWindow.h"


//******************************************************************************************************
//**** Global variables
//******************************************************************************************************
const char* c_tetris_sig = "application/x-vnd.BT-Tetris";


//******************************************************************************************************
//**** Tetris
//******************************************************************************************************
int main(int argc, char** argv)
{
	new TetrisApplication();
	be_app->Run();
	return 0;
}


//******************************************************************************************************
//**** TetrisApplication
//******************************************************************************************************
TetrisApplication::TetrisApplication()
: BApplication(c_tetris_sig)
{
	m_resources = new TetrisResources();
	m_prefs = new TetrisPrefs();

	bool ok = m_resources->InitCheck();
	BAlert* alert;
	if(!ok)
	{
		alert = new BAlert(NULL,"Tetris was unable to load its resources.","Quit",NULL,NULL,
			B_WIDTH_AS_USUAL,B_OFFSET_SPACING,B_STOP_ALERT);
		alert->Go();
		return;
	}
	ok = m_prefs->InitCheck();
	if(!ok)
	{
		alert = new BAlert(NULL,g_init_prefs_fail_string,g_quit_string,NULL,
			NULL,B_WIDTH_AS_USUAL,B_OFFSET_SPACING,B_STOP_ALERT);
		alert->Go();
		return;
	}

	new TetrisWindow();
}


TetrisApplication::~TetrisApplication()
{
	delete m_prefs;
	delete m_resources;
}


void TetrisApplication::AboutRequested()
{
	if(m_about_window_messenger.IsValid())
		m_about_window_messenger.SendMessage(c_about_window_to_front);
	else
	{
		//Create it
		AboutWindow* about_window = new AboutWindow(g_tetris_string,"AboutTetrisLogo",16,g_about_text);
		m_about_window_messenger = BMessenger(NULL,about_window);
		if(m_about_window_messenger.IsValid())
			about_window->Show();
		else
			about_window->Quit();
	}
}
