#ifndef	SettingViewH
#define	SettingViewH
//------------------------------------------------------------------------------
#include <Alert.h>
#include <Application.h>
#include <Box.h>
#include <Button.h>
#include <ColorControl.h>
#include <Point.h>
#include <RadioButton.h>
#include <StringView.h>
#include <TextControl.h>
#include <View.h>
#include <stdio.h>
//#include <string.h>
#include "Common.h"
//------------------------------------------------------------------------------
const int	SetViewButtonWidth = 70;
const int	SetViewTxtCtrlWidth = 70;
//------------------------------------------------------------------------------
const uint32	BUTTONCANCEL_CLICKED = 'cncl';
const uint32	COLCTRL_CHANGED = 'colc';
const uint32	BUTTONEMPTYCOL_CLICKED = 'eptc';
const uint32	BUTTONHELP_CLICKED = 'help';
const uint32	BUTTONLIFECOL_CLICKED = 'lifc';
const uint32	BUTTONOK_CLICKED = 'ok';
const uint32	BUTTONPANELCOL_CLICKED = 'pnlc';
//------------------------------------------------------------------------------
class TSettingView : public BView
{
private:
	virtual void	AttachedToWindow();
	void			ButtonCancelClicked();
	void			ButtonEmptyColClicked();
	void			ButtonHelpClicked();
	void			ButtonLifeColClicked();
	void			ButtonOKClicked();
	void			ButtonPanelColClicked();
	void			ColCtrlChanged();
	virtual void	Draw(BRect Rect);
	void			DrawCurrentCol();	//現在選択中の色を描画
	void			DrawTriCol();		//３つの色を描画
	virtual void	MessageReceived(BMessage *xMsg);
	
	int				iResult;			//SetWin::Go()の戻り値
	BBox			*mxBoxCol;
	BButton			*mxButtonCancel;
	BButton			*mxButtonEmptyCol;
	BButton			*mxButtonHelp;
	BButton			*mxButtonLifeCol;
	BButton			*mxButtonOK;
	BButton			*mxButtonPanelCol;
	BColorControl	*mxColCtrl;
	BRadioButton	*mxRButtonLang[2];
	BTextControl	*mxTxtCtrlInterval;
	BTextControl	*mxTxtCtrlXBlocks;
	BTextControl	*mxTxtCtrlYBlocks;
	BTextControl	*mxTxtCtrlXBlockSize;
	BTextControl	*mxTxtCtrlYBlockSize;
	TCustomSet		*mxNewCustomSet;
protected:
public:
	TSettingView(BRect xFrame,TCustomSet *xNewCustomSet);
	~TSettingView();
	int		Result();					//戻り値
};
//------------------------------------------------------------------------------
#endif	//SettingViewH
