/*****************************************************************************

	Projet	: Droids

	Fichier	:	bCSound.h
	Partie	: Sons

	Auteur	: RM
	Date		: 210297 -- release today !! yeah !
	Format	: tabs==2

*****************************************************************************/

#ifndef _H_BCSOUND_
#define _H_BCSOUND_

#include "machine.h"
#include "gCSem.h"

// BeOS classes forward defs
class BSubscriber;
class BDACStream;

//---------------------------------------------------------------------------
// a Be audio buffer is currently 4Kb.
// I do sample at 22.05 kHz, mono, 16 bits, signed, big-endian.
// Thus a sample is %d seconds longs.
// 4kb/16bits/mono ==> 4096/2 ==> 2048 samples in a buffer (I'm tired :=p).
// 22050 Hz --> a sample is 4.535147392e-05 seconds longs
// so buffer is 92.87981859 milliseconds longs.
// At a pseudo frame rate of 25 fps, there are 0.43 buffers per frame
// or 2.32 frames per buffer.

#define K_SAMPLE_SIZE	4096

// max loaded and playing at the same time

#define K_MAX_SINGLE	30
#define K_MAX_REPEAT	10


//---------------------------------------------------------------------------
// def repertoire des sons

#define K_SOUND_DIR_NAME "nerdkill_sound"

// defs sons Singles
enum
{
	kSoundNerdIn,		// "nerd_in.22m"
	kSoundNerdOut,	// "nerd_out.22m"
	kSoundGun,			//" n_gun.22m"
	kSoundElec,			// "n_elec1.22m"
	kSoundSelect,		// "n_select.22m"
	kSoundExplose,	// "n_explos.22m"
	kSoundMine,			// "n_mine.22m"
	kSoundFun1,			// "nerdfun1.22m"
	kSoundFun2,			// "nerdfun2.22m"
	kSoundFun3,			// "nerdfun3.22m"
	kSoundFun4,			// "nerdfun4.22m"
	kSoundFun5,			// "nerdfun5.22m"
	kSoundAh1,			// "n_ah1.22m"
	kSoundAh2,			// "n_ah2.22m"
	kSoundAh3,			// "n_ah3.22m"
	kSoundAh4,			// "n_ah4.22m"
	kSoundAh5,			// "n_ah5.22m"
	kSoundAh6,			// "n_ah6.22m"
	kSoundAh7,			// "n_ah7.22m"
	kSoundAh8,			// "n_ah8.22m"
	kSoundAh9,			// "n_ah9.22m"
	kSoundAh10,			// "n_ah10.22m"
	kSoundRouleau2	// "n_roul2.22m"
};

#define K_NB_SOUND_AH	10
#define K_NB_SOUND_FUN 5

// defs son Repeats
enum
{
	kSoundUzi,			//" n_gun.22m"
	kSoundRouleau1		// "n_roul1.22m"
};


//---------------------------------------------------------------------------


//***********
struct SSound
//***********
{
	SSound(void) { data = NULL; repeat = play = false; realSize = allocSize = count = offset = 0;}
	~SSound(void) { if (data) delete data; }

	bool repeat;
	bool play;
	ULONG offset;			// current offset in buffer IN BYTES !
	WORD  *data;			// upgraded to a 4 kb boundary __allways__ !!
	ULONG realSize;		// IN BYTES
	ULONG allocSize;	// upgraded to a 4 kb boundary -- IN BYTES
	ULONG	count;			// for singles
};




//**********
class CSound
//**********
{
public:
	CSound(void);
	virtual ~CSound(void);

	BOOL init(void);		// will subscribe
	void start(void);		// will enter the stream
	void stop(void);		// will exit the stream and sunsubscribe

	BOOL loadAllSound(void);	// called by init
	BOOL loadSound(SSound *sound, WORD *buf, ULONG realsize);

	#ifdef B_BEOS_VERSION_3
		static bool streamEntry(void *user, char *buffer, size_t size, void *header);
	#elif B_BEOS_VERSION_4
		static void sPlayBuffer(void *user, void *buffer, size_t size, const media_raw_audio_format &format);
	#endif

	void process(char *buffer, long size);
	void processFloat(float *buffer, long size);

	void addSingle(ULONG index);
	BOOL hasSingle(ULONG index);	// is currently playing ?

	void addRepeat(ULONG index);
	void removeRepeat(ULONG index);
	void toggleRepeat(ULONG index);
	BOOL hasRepeat(ULONG index);	// is currently playing ?

//----
protected:

	BDirectory				mDirSon;

	#ifdef B_BEOS_VERSION_3
		BSubscriber			 	*mAudioSub;
		BDACStream				*mAudioStream;
	#elif B_BEOS_VERSION_4
		BSoundPlayer			*mSoundPlayer;
	#endif

	ULONG	mNbLoadRepeat;		// nb currently loaded
	ULONG	mNbLoadSingle;		// nb currently loaded

	ULONG	mNbRepeat;				// nb currently playing
	ULONG	mNbSingle;				// nb currently playing

	SSound	*mSingle;
	SSound	*mRepeat;

	CSem	mSingleSem;
	CSem	mRepeatSem;

}; // end of class defs for CSound


//---------------------------------------------------------------------------

#endif // of _H_BCSOUND_

// eoh
