/*********************************************************************
HyperTTT - Tic tac toe in higher dimensions
Copyright (c) 1998 Brian Nenninger

This program is free software; you can redistribute it and/or modify it under 
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with 
this program; if not, write to the Free Software Foundation, Inc., 675 Mass 
Ave., Cambridge, MA 02139, USA.

You may contact me at bwn@kreative.net
************************************************************************/

#ifndef BeSCOREVIEW_H
#define BeSCOREVIEW_H

#include <View.h>

class BeTTTWindow;
class BeTTTGame;

class BeScoreView : public BView
{
protected:
  BeTTTGame *m_game;
  BeTTTWindow *m_parent;
	
  int m_lastP1Wins, m_lastP2Wins, m_lastTies;
  int m_p1Width, m_p2Width, m_tiesWidth;
  char m_p1str[10], m_p2str[10], m_tiestr[10];
  
public:
  BeScoreView(BRect, char*);
  ~BeScoreView();
  
  void SetGame(BeTTTGame *);
  void SetParent(BeTTTWindow *);
  
  virtual void Draw(BRect);  
};

#endif
