/*********************************************************************
HyperTTT - Tic tac toe in higher dimensions
Copyright (c) 1998 Brian Nenninger

This program is free software; you can redistribute it and/or modify it under 
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with 
this program; if not, write to the Free Software Foundation, Inc., 675 Mass 
Ave., Cambridge, MA 02139, USA.

You may contact me at bwn@kreative.net
************************************************************************/

#include "BeAboutView.h"
#include "BeTTTWindow.h"

BeAboutView::BeAboutView(BRect rect, char *name)
	   	   : BView(rect, name, B_FOLLOW_ALL, B_WILL_DRAW | B_FRAME_EVENTS |
	   	                                     (0*B_FULL_UPDATE_ON_RESIZE) | (0*B_PULSE_NEEDED))
{
  //SetFontName("Courier New");
  SetFontSize(12);
  
  m_numLines = 5;
  m_maxlen   = 80;
  m_lines = new char* [m_numLines];
  m_strWidths = new int[m_numLines];
  int i;
  for(i=0; i<m_numLines; i++)
  {
    m_lines[i] = new char[m_maxlen];
  }
  strcpy(m_lines[0], "Hyper TTT 0.95");
  strcpy(m_lines[1], "Copyright(c) 1998 Brian Nenninger (bwn@kreative.net)");
  strcpy(m_lines[2], "Hyper TTT comes with ABSOLUTELY NO WARRANTY");
  strcpy(m_lines[3], "This is free software, see the included");
  strcpy(m_lines[4], "GNU General Public License for details.");  
  
  m_maxWidth = 0;
  for(i=0; i<m_numLines; i++)
  {
    m_strWidths[i] = (int)StringWidth(m_lines[i]);
    if (m_strWidths[i] > m_maxWidth)
      m_maxWidth = m_strWidths[i];
  }
  
  // fix our size so the strings will fit
  ResizeTo(m_maxWidth+12, 20*m_numLines+10);
  m_bounds = Bounds();
}

BeAboutView::~BeAboutView()
{
  int i;
  for(i=0; i<m_numLines; i++)
  {
    delete [] m_lines[i];
  }
  delete [] m_lines;
  delete [] m_strWidths;
  
  m_parent->AboutWindowClosed();
}

void BeAboutView::SetParent(BeTTTWindow *w)
{
  m_parent = w;
}
/*
int BeAboutView::GetMaxWidth()
{
  
}
*/
void BeAboutView::Draw(BRect r)
{
  int i;
  int mid = (m_bounds.left+m_bounds.right)/2;
  for(i=0; i<m_numLines; i++)
  {
    MovePenTo(mid - (m_strWidths[i]/2), 20+20*i);
    DrawString(m_lines[i]);
  }
}