/*********************************************************************
HyperTTT - Tic tac toe in higher dimensions
Copyright (c) 1998 Brian Nenninger

This program is free software; you can redistribute it and/or modify it under 
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with 
this program; if not, write to the Free Software Foundation, Inc., 675 Mass 
Ave., Cambridge, MA 02139, USA.

You may contact me at bwn@kreative.net
************************************************************************/

// type definitions for the game board

#ifndef TTTBOARD_H
#define TTTBOARD_H

// N and D are globals for size and dimension of board
#define HUMAN   10
#define DEFEND   0
#define ATTACK   1
#define BALANCED 2

#define TIE 1
#define WIN 2

#define EMPTY 0


class Vector
{
  signed char x[6];
public:
  Vector();
  ~Vector();
  
  void Set0();
  // next 2 are equivalent
  void Inc();
  void operator++();
  void operator++(int n);
  
  void Set(int n, int val);
  // next 2 are equivalent
  int Get(int n);
  int operator[](int n);
   
  Vector operator+(Vector &v);
  Vector operator-(Vector &v);
  Vector operator-();
  void operator+=(Vector &v);
  void operator-=(Vector &v);
  Vector operator*(int k);
  friend Vector operator*(int k, Vector &v);
  Vector operator=(Vector &v);
  int operator==(Vector &v);
  
  int IsMax();
  int IsEdge();
  int IsLegal();
  int Normalize();
  int LegalDir(Vector &dv);
};

typedef Vector *VectorPtr;

class Board
{
  unsigned char *x;
  int size;
public:
  int numCells;
  Board();
  ~Board();
  
  void Set(Vector &v, int val);
  void Set0();
  int  IsEmpty();
  // next 2 are equivalent
  int Get(Vector &v);
  int operator[](Vector &v);
  
  int ThreatLen(Vector &v, Vector &dv, int threatVal);
  void GetThreats(Vector &threatPos, int threatVal, 
                     VectorPtr &threatList, int *listSize, int *threatSize);
};


class ThreatLine
{
public:
  Vector v, dv;
  void operator=(ThreatLine &t);
  int operator==(ThreatLine &t);
  int HitsCell(Vector &v);
};

class ThreatList
{
public:  
  int listLen, numMaxThreats, maxThreatLen;
  ThreatLine *lineList;
  unsigned char *lenList;
  ThreatList();
  ~ThreatList();
//  void CheckLines(Board &b, int val);
  void UpdateAfterMove(Vector &v);
};


class Player
{
public:
  ThreatList winLines, loseLines;
  int strategy;
  
  Player();
  void ComputeBestOffenseMove(Board &b, int val, Vector *move);
  void ComputeBestDefenseMove(Board &b, int val, Vector *move);
  int  ComputeBestMove(Board &b, int val, Vector *move);
  void MakeFirstMove(Board &b, Vector *move);
  // functions for each type of strategy
  int DefendMove(Board &b, int val, Vector *move);
  int BalancedMove(Board &b, int val, Vector *move);
  int AttackMove(Board &b, int val, Vector *move);
  // functions to react to moves
  int AddNewThreats(Board &b, ThreatList &tList, int val, Vector &move);
  void RemoveBlockedThreats(Board &b, ThreatList &tList, int val, Vector &move);
  int RespondToMove(Board &b, int val, Vector *move);
  int UpdateThreats(Board &b, int val, Vector *move);
  
  int MakeMove(Board &b, int val, Vector *move);
};


// prototypes to make the warning checker happy
int Rand(int);
void SwapUC(unsigned char *, unsigned char *);
void SwapTL(ThreatLine *, ThreatLine *);
void SortThreatList(unsigned char *, ThreatLine *, int);

#endif
