#include "SettingView.h"
//------------------------------------------------------------------------------
TSettingView::TSettingView(BRect xFrame,TCustomSet *xNewCustomSet)
		: BView(xFrame,"SettingView",B_FOLLOW_ALL,B_WILL_DRAW)
{
	mxNewCustomSet = xNewCustomSet;
	iResult = IDNone;
}
//------------------------------------------------------------------------------
TSettingView::~TSettingView()
{
}
//------------------------------------------------------------------------------
void TSettingView::AttachedToWindow()
{
	char			szTmp[256];
	font_height		xFontHeight;
	BBox			*xBoxBlockSize;
	BBox			*xBoxLang;
	BBox			*xBoxMapSize;
	BRect			xButtonFrame;
	BRect			xTmpFrame;
	BRect			xStrViewFrame;
	BRect			xTxtCtrlFrame;
	BStringView		*xStrViewInterval;
	BStringView		*xStrViewXBlocks;
	BStringView		*xStrViewYBlocks;
	BStringView		*xStrViewXBlockSize;
	BStringView		*xStrViewYBlockSize;
	
	GetFontHeight(&xFontHeight);
	xStrViewFrame.Set(0,0,StringWidth(gxLLMsg->mxLabelWidth.String()),xFontHeight.ascent
			+xFontHeight.descent);
	xTxtCtrlFrame.Set(0,0,SetViewTxtCtrlWidth,0);
	xBoxMapSize = new BBox(BRect(CmpMargin,CmpMargin,0,0));
		xBoxMapSize->SetLabel(gxLLMsg->mxBoxField.String());
		xStrViewFrame.OffsetTo(CmpMargin,CmpMargin*2);
		xStrViewXBlocks = new BStringView(xStrViewFrame,NULL,gxLLMsg->mxLabelWidth.String());
		xBoxMapSize->AddChild(xStrViewXBlocks);
		xTxtCtrlFrame.OffsetTo(xStrViewXBlocks->Frame().right+CmpMargin
				,xStrViewXBlocks->Frame().top);
		sprintf(szTmp,"%d",mxNewCustomSet->miXBlocks);
		mxTxtCtrlXBlocks = new BTextControl(xTxtCtrlFrame,NULL,NULL
				,szTmp,NULL);
		mxTxtCtrlXBlocks->SetAlignment(B_ALIGN_RIGHT,B_ALIGN_RIGHT);
		xBoxMapSize->AddChild(mxTxtCtrlXBlocks);
		xStrViewFrame.OffsetTo(CmpMargin,xStrViewXBlocks->Frame().bottom+CmpMargin);
		xStrViewYBlocks = new BStringView(xStrViewFrame,NULL,gxLLMsg->mxLabelHeight.String());
		xBoxMapSize->AddChild(xStrViewYBlocks);
		xTxtCtrlFrame.OffsetTo(xStrViewYBlocks->Frame().right+CmpMargin
				,xStrViewYBlocks->Frame().top);
		sprintf(szTmp,"%d",mxNewCustomSet->miYBlocks);
		mxTxtCtrlYBlocks = new BTextControl(xTxtCtrlFrame,NULL,NULL
				,szTmp,NULL);
		mxTxtCtrlYBlocks->SetAlignment(B_ALIGN_RIGHT,B_ALIGN_RIGHT);
		xBoxMapSize->AddChild(mxTxtCtrlYBlocks);
		xBoxMapSize->ResizeTo(mxTxtCtrlYBlocks->Frame().right+CmpMargin
				,mxTxtCtrlYBlocks->Frame().bottom+CmpMargin);
	AddChild(xBoxMapSize);
	xTmpFrame = xBoxMapSize->Frame();
	xTmpFrame.OffsetTo(xBoxMapSize->Frame().right+CmpMargin,xBoxMapSize->Frame().top);
	xBoxBlockSize = new BBox(xTmpFrame);
		xBoxBlockSize->SetLabel(gxLLMsg->mxBoxBlock.String());
		xStrViewFrame.OffsetTo(CmpMargin,CmpMargin*2);
		xStrViewXBlockSize = new BStringView(xStrViewFrame,NULL,gxLLMsg->mxLabelWidth.String());
		xBoxBlockSize->AddChild(xStrViewXBlockSize);
		xTxtCtrlFrame.OffsetTo(xStrViewXBlockSize->Frame().right+CmpMargin
				,xStrViewXBlockSize->Frame().top);
		sprintf(szTmp,"%d",mxNewCustomSet->miXBlockSize);
		mxTxtCtrlXBlockSize = new BTextControl(xTxtCtrlFrame,NULL,NULL
				,szTmp,NULL);
		mxTxtCtrlXBlockSize->SetAlignment(B_ALIGN_RIGHT,B_ALIGN_RIGHT);
		xBoxBlockSize->AddChild(mxTxtCtrlXBlockSize);
		xStrViewFrame.OffsetTo(CmpMargin,xStrViewXBlockSize->Frame().bottom+CmpMargin);
		xStrViewYBlockSize = new BStringView(xStrViewFrame,NULL,gxLLMsg->mxLabelHeight.String());
		xBoxBlockSize->AddChild(xStrViewYBlockSize);
		xTxtCtrlFrame.OffsetTo(xStrViewYBlockSize->Frame().right+CmpMargin
				,xStrViewYBlockSize->Frame().top);
		sprintf(szTmp,"%d",mxNewCustomSet->miYBlockSize);
		mxTxtCtrlYBlockSize = new BTextControl(xTxtCtrlFrame,NULL,NULL
				,szTmp,NULL);
		mxTxtCtrlYBlockSize->SetAlignment(B_ALIGN_RIGHT,B_ALIGN_RIGHT);
		xBoxBlockSize->AddChild(mxTxtCtrlYBlockSize);
		xBoxBlockSize->ResizeTo(mxTxtCtrlYBlockSize->Frame().right+CmpMargin
				,mxTxtCtrlYBlockSize->Frame().bottom+CmpMargin);
	AddChild(xBoxBlockSize);
	xButtonFrame.Set(0,0,SetViewButtonWidth,ButtonHeight);
	mxBoxCol = new BBox(BRect(CmpMargin,xBoxMapSize->Frame().bottom+CmpMargin,0,0)
			,"BoxCol");
		mxBoxCol->SetLabel(gxLLMsg->mxBoxCol.String());
		mxColCtrl = new BColorControl(BPoint(CmpMargin,CmpMargin*2),B_CELLS_32x8
				,(mxTxtCtrlXBlocks->Frame().bottom-mxTxtCtrlXBlocks->Frame().top)/2,NULL
				,new BMessage(COLCTRL_CHANGED));
		mxBoxCol->AddChild(mxColCtrl);
		xButtonFrame.OffsetTo(CmpMargin,mxColCtrl->Frame().bottom+CmpMargin);
		mxButtonPanelCol = new BButton(xButtonFrame,NULL,gxLLMsg->mxButtonPanelCol.String()
				,new BMessage(BUTTONPANELCOL_CLICKED));
		mxBoxCol->AddChild(mxButtonPanelCol);
		xButtonFrame.OffsetTo(mxButtonPanelCol->Frame().right+CmpMargin
				,mxColCtrl->Frame().bottom+CmpMargin);
		mxButtonLifeCol = new BButton(xButtonFrame,NULL,gxLLMsg->mxButtonLifeCol.String()
				,new BMessage(BUTTONLIFECOL_CLICKED));
		mxBoxCol->AddChild(mxButtonLifeCol);
		xButtonFrame.OffsetTo(mxButtonLifeCol->Frame().right+CmpMargin
				,mxColCtrl->Frame().bottom+CmpMargin);
		mxButtonEmptyCol = new BButton(xButtonFrame,NULL,gxLLMsg->mxButtonEmptyCol.String()
				,new BMessage(BUTTONEMPTYCOL_CLICKED));
		mxBoxCol->AddChild(mxButtonEmptyCol);
		mxBoxCol->ResizeTo(mxColCtrl->Frame().right+CmpMargin
				,mxButtonPanelCol->Frame().bottom+ButtonHeight+CmpMargin*2);
	AddChild(mxBoxCol);
	xTmpFrame.Set(0,0,StringWidth(gxLLMsg->mxLabelInterval.String()),xFontHeight.ascent
			+xFontHeight.descent);
	xTmpFrame.OffsetTo(CmpMargin,mxBoxCol->Frame().bottom+CmpMargin);
	xStrViewInterval = new BStringView(xTmpFrame,NULL,gxLLMsg->mxLabelInterval.String());
	AddChild(xStrViewInterval);
	xTxtCtrlFrame.OffsetTo(xStrViewInterval->Frame().right+CmpMargin
			,xStrViewInterval->Frame().top);
	sprintf(szTmp,"%d",mxNewCustomSet->miInterval);
	mxTxtCtrlInterval = new BTextControl(xTxtCtrlFrame,NULL,NULL,szTmp,NULL);
	mxTxtCtrlInterval->SetAlignment(B_ALIGN_RIGHT,B_ALIGN_RIGHT);
	AddChild(mxTxtCtrlInterval);
	xTmpFrame.Set(xStrViewInterval->Frame().left,xStrViewInterval->Frame().bottom+CmpMargin,0,0);
	xBoxLang = new BBox(xTmpFrame);
		xBoxLang->SetLabel(gxLLMsg->mxBoxLang.String());
		xTmpFrame.Set(0,0,StringWidth(gxLLMsg->mxRButtonLang[0].String())+30,xFontHeight.ascent);
		xTmpFrame.OffsetTo(CmpMargin,CmpMargin*2);
		mxRButtonLang[0] = new BRadioButton(xTmpFrame,NULL,gxLLMsg->mxRButtonLang[0].String()
				,NULL);
		xBoxLang->AddChild(mxRButtonLang[0]);
		xTmpFrame.Set(0,0,StringWidth(gxLLMsg->mxRButtonLang[1].String())+30,xFontHeight.ascent);
		xTmpFrame.OffsetTo(CmpMargin,mxRButtonLang[0]->Frame().bottom+CmpMargin);
		mxRButtonLang[1] = new BRadioButton(xTmpFrame,NULL,gxLLMsg->mxRButtonLang[1].String()
				,NULL);
		xBoxLang->AddChild(mxRButtonLang[1]);
		mxRButtonLang[mxNewCustomSet->miLang]->SetValue(B_CONTROL_ON);
		xBoxLang->ResizeTo(Max(mxRButtonLang[0]->Frame().right,mxRButtonLang[1]->Frame().right)+CmpMargin
				,mxRButtonLang[1]->Frame().bottom+CmpMargin);
	AddChild(xBoxLang);
	xButtonFrame.OffsetTo(mxBoxCol->Frame().right-SetViewButtonWidth
			,xBoxLang->Frame().bottom-ButtonHeight*2-CmpMargin);
	mxButtonHelp = new BButton(xButtonFrame,NULL,gxLLMsg->mxButtonHelp.String()
			,new BMessage(BUTTONHELP_CLICKED));
	AddChild(mxButtonHelp);
	xButtonFrame.OffsetTo(mxBoxCol->Frame().right-SetViewButtonWidth*2-CmpMargin
			,xBoxLang->Frame().bottom-ButtonHeight);
	mxButtonCancel = new BButton(xButtonFrame,NULL,gxLLMsg->mxButtonCancel.String()
			,new BMessage(BUTTONCANCEL_CLICKED));
	AddChild(mxButtonCancel);
	xButtonFrame.OffsetTo(mxBoxCol->Frame().right-SetViewButtonWidth
			,xBoxLang->Frame().bottom-ButtonHeight);
	mxButtonOK = new BButton(xButtonFrame,"ButtonOK",gxLLMsg->mxButtonOK.String()
			,new BMessage(BUTTONOK_CLICKED));
	mxButtonOK->MakeDefault(true);
	AddChild(mxButtonOK);

	mxButtonPanelCol->SetTarget(this);
	mxButtonLifeCol->SetTarget(this);
	mxButtonEmptyCol->SetTarget(this);
	mxButtonHelp->SetTarget(this);
	mxButtonOK->SetTarget(this);
	mxButtonCancel->SetTarget(this);
	mxColCtrl->SetTarget(this);
	mxTxtCtrlXBlocks->MakeFocus();
}
//------------------------------------------------------------------------------
void	TSettingView::ButtonCancelClicked()
{
	iResult = IDCancel;
}
//------------------------------------------------------------------------------
void	TSettingView::ButtonEmptyColClicked()
{
	mxNewCustomSet->mxEmptyColor = mxColCtrl->ValueAsColor();
	DrawTriCol();
}
//------------------------------------------------------------------------------
void	TSettingView::ButtonHelpClicked()
{
	ShowHelp();
}
//------------------------------------------------------------------------------
void	TSettingView::ButtonLifeColClicked()
{
	mxNewCustomSet->mxLifeColor = mxColCtrl->ValueAsColor();
	DrawTriCol();
}
//------------------------------------------------------------------------------
void	TSettingView::ButtonOKClicked()
{
	mxNewCustomSet->miXBlocks = StrToInt(mxTxtCtrlXBlocks->Text(),MapBlockMaxFig);
	if ( mxNewCustomSet->miXBlocks < 2 )
		mxNewCustomSet->miXBlocks = 2;
	mxNewCustomSet->miYBlocks = StrToInt(mxTxtCtrlYBlocks->Text(),MapBlockMaxFig);
	if ( mxNewCustomSet->miYBlocks < 2 )
		mxNewCustomSet->miYBlocks = 2;
	mxNewCustomSet->miXBlockSize = StrToInt(mxTxtCtrlXBlockSize->Text(),BlockSizeMaxFig);
	if ( mxNewCustomSet->miXBlockSize < 1 )
		mxNewCustomSet->miXBlockSize = 1;
	mxNewCustomSet->miYBlockSize = StrToInt(mxTxtCtrlYBlockSize->Text(),BlockSizeMaxFig);
	if ( mxNewCustomSet->miYBlockSize < 1 )
		mxNewCustomSet->miYBlockSize = 1;
	mxNewCustomSet->miInterval = StrToInt(mxTxtCtrlInterval->Text(),IntervalMaxFig);
	if ( mxNewCustomSet->miInterval < 50 )
		mxNewCustomSet->miInterval = 50;
	mxNewCustomSet->miLang = mxRButtonLang[1]->Value();
	iResult = IDOK;
#ifdef DEBUGz
	int a = IDOK;
	int b = iResult;
#endif
}
//------------------------------------------------------------------------------
void	TSettingView::ButtonPanelColClicked()
{
	mxNewCustomSet->mxCtrlViewColor = mxColCtrl->ValueAsColor();
	DrawTriCol();
}
//------------------------------------------------------------------------------
void	TSettingView::ColCtrlChanged()
{
	DrawCurrentCol();
}
//------------------------------------------------------------------------------
void	TSettingView::Draw(BRect Rect)
{
	DrawTriCol();
	DrawCurrentCol();
}
//------------------------------------------------------------------------------
void	TSettingView::DrawCurrentCol()
{
	mxBoxCol->SetHighColor(mxColCtrl->ValueAsColor());
	mxBoxCol->FillRect(BRect(mxButtonEmptyCol->Frame().right+CmpMargin
			,mxButtonEmptyCol->Frame().top,mxColCtrl->Frame().right
			,mxButtonEmptyCol->Frame().bottom+ButtonHeight+CmpMargin));
	mxBoxCol->SetHighColor(0,0,0);
}
//------------------------------------------------------------------------------
void	TSettingView::DrawTriCol()
{
	BRect	xFrame;
	
	xFrame = mxButtonPanelCol->Frame();
	mxBoxCol->SetHighColor(mxNewCustomSet->mxCtrlViewColor);
	xFrame.OffsetTo(mxButtonPanelCol->Frame().left,mxButtonPanelCol->Frame().bottom+CmpMargin);
	mxBoxCol->FillRect(xFrame);
	mxBoxCol->SetHighColor(mxNewCustomSet->mxLifeColor);
	xFrame.OffsetTo(mxButtonLifeCol->Frame().left,mxButtonLifeCol->Frame().bottom+CmpMargin);
	mxBoxCol->FillRect(xFrame);
	mxBoxCol->SetHighColor(mxNewCustomSet->mxEmptyColor);
	xFrame.OffsetTo(mxButtonEmptyCol->Frame().left,mxButtonEmptyCol->Frame().bottom+CmpMargin);
	mxBoxCol->FillRect(xFrame);
	mxBoxCol->SetHighColor(0,0,0);
}
//------------------------------------------------------------------------------
void TSettingView::MessageReceived(BMessage *xMsg)
{
	switch ( xMsg->what ) {
		case BUTTONCANCEL_CLICKED:
			ButtonCancelClicked();
			break;
		case BUTTONEMPTYCOL_CLICKED:
			ButtonEmptyColClicked();
			break;
		case BUTTONHELP_CLICKED:
			ButtonHelpClicked();
			break;
		case BUTTONLIFECOL_CLICKED:
			ButtonLifeColClicked();
			break;
		case BUTTONOK_CLICKED:
			ButtonOKClicked();
			break;
		case BUTTONPANELCOL_CLICKED:
			ButtonPanelColClicked();
			break;
		case COLCTRL_CHANGED:
			ColCtrlChanged();
			break;
		default:
			BView::MessageReceived(xMsg);
	}
}
//------------------------------------------------------------------------------
int		TSettingView::Result()
{
	return iResult;
}
//------------------------------------------------------------------------------
