#include "BeNaLifeWindow.h"
//------------------------------------------------------------------------------
TBeNaLifeWindow::TBeNaLifeWindow(BRect xFrame)
		: BWindow(xFrame,gxLLMsg->mxAppInfo[0].String(),B_DOCUMENT_WINDOW,0)
{
	BMenu			*xMenu;
	BMenuItem		*xMItem;
	BRect			xDummyFrame;
	TBeNaLifeView	*xBLView;
	
#ifdef DEBUG
	char		szTitle[256];
	strcpy(szTitle,"［デバッグ］ ");
	strcat(szTitle,gxLLMsg->mxAppInfo[0].String());
	SetTitle(szTitle);
#endif
	xDummyFrame.Set(0,0,0,0);
	mxMBar = new BMenuBar(xDummyFrame,"MenuBar");
	AddChild(mxMBar);
	xFrame.OffsetTo(B_ORIGIN);
	xFrame.top += mxMBar->Frame().Height()+1;
	xBLView = new TBeNaLifeView(xFrame);
	AddChild(xBLView);
	mxCtrlView = (TCtrlView *)xBLView->FindView("CtrlView");
	mxFieldView = (TFieldView *)xBLView->FindView("FieldView");
	mxMenuFile = new BMenu(gxLLMsg->mxMenuFile[mipFile].String());
		mxMItemNew = new BMenuItem(gxLLMsg->mxMenuFile[miNew].String(),new BMessage(MENUNEW_CLICKED),'N');
		mxMItemNew->SetTarget(mxFieldView);
		mxMenuFile->AddItem(mxMItemNew);
		mxMItemOpen = new BMenuItem(gxLLMsg->mxMenuFile[miOpen].String(),new BMessage(MENUOPEN_CLICKED),'O');
		mxMItemOpen->SetTarget(mxFieldView);
		mxMenuFile->AddItem(mxMItemOpen);
		mxMenuFile->AddSeparatorItem();
		mxMItemSave = new BMenuItem(gxLLMsg->mxMenuFile[miSave].String(),new BMessage(MENUSAVE_CLICKED),'S');
		mxMItemSave->SetTarget(mxFieldView);
		mxMenuFile->AddItem(mxMItemSave);
		mxMItemSaveAs = new BMenuItem(gxLLMsg->mxMenuFile[miSaveAs].String(),new BMessage(MENUSAVEAS_CLICKED),'2');
		mxMItemSaveAs->SetTarget(mxFieldView);
		mxMenuFile->AddItem(mxMItemSaveAs);
		mxMenuFile->AddSeparatorItem();
		xMItem = new BMenuItem(gxLLMsg->mxMenuFile[miQuit].String(),new BMessage(B_QUIT_REQUESTED),'Q');
		mxMenuFile->AddItem(xMItem);
	mxMBar->AddItem(mxMenuFile);
	mxMenuEdit = new BMenu(gxLLMsg->mxMenuEdit[mipEdit].String());
		mxMItemCut = new BMenuItem(gxLLMsg->mxMenuEdit[miCut].String(),new BMessage(B_CUT),'X');
		mxMenuEdit->AddItem(mxMItemCut);
		mxMItemCopy = new BMenuItem(gxLLMsg->mxMenuEdit[miCopy].String(),new BMessage(B_COPY),'C');
		mxMenuEdit->AddItem(mxMItemCopy);
		mxMItemPaste = new BMenuItem(gxLLMsg->mxMenuEdit[miPaste].String(),new BMessage(B_PASTE),'V');
		mxMenuEdit->AddItem(mxMItemPaste);
		mxMenuEdit->AddSeparatorItem();
		mxMItemSelAll = new BMenuItem(gxLLMsg->mxMenuEdit[miSelAll].String(),new BMessage(B_SELECT_ALL),'A');
		mxMenuEdit->AddItem(mxMItemSelAll);
		mxMenuEdit->SetTargetForItems(mxFieldView);
	mxMBar->AddItem(mxMenuEdit);
	mxMenuGene = new BMenu(gxLLMsg->mxMenuGene[mipGene].String());
		mxMItemGo = new BMenuItem(gxLLMsg->mxMenuGene[miGo].String(),new BMessage(MENUGOSTOP_CLICKED),'G');
		mxMenuGene->AddItem(mxMItemGo);
		mxMItemStop = new BMenuItem(gxLLMsg->mxMenuGene[miStop].String(),new BMessage(MENUGOSTOP_CLICKED),'N');
		mxMenuGene->AddItem(mxMItemStop);
		mxMItemStep = new BMenuItem(gxLLMsg->mxMenuGene[miStep].String(),new BMessage(MENUSTEP_CLICKED),'T');
		mxMenuGene->AddItem(mxMItemStep);
		mxMItemEnbloc = new BMenuItem(gxLLMsg->mxMenuGene[miEnbloc].String(),new BMessage(MENUENBLOC_CLICKED),'E');
		mxMenuGene->AddItem(mxMItemEnbloc);
		mxMenuGene->SetTargetForItems(mxFieldView);
	mxMBar->AddItem(mxMenuGene);
	mxMenuTool = new BMenu(gxLLMsg->mxMenuTool[mipTool].String());
		mxMItemSetting = new BMenuItem(gxLLMsg->mxMenuTool[miPref].String(),new BMessage(MENUSETTING_CLICKED),'P');
		mxMenuTool->AddItem(mxMItemSetting);
		xMItem = new BMenuItem(gxLLMsg->mxMenuTool[miRTF].String(),new BMessage(MENURESIZETOFIT_CLICKED),'F');
		mxMenuTool->AddItem(xMItem);
		mxMenuTool->AddSeparatorItem();
		mxMItemRandom = new BMenuItem(gxLLMsg->mxMenuTool[miRandom].String(),new BMessage(MENURANDOM_CLICKED),'R');
		mxMItemRandom->SetTarget(mxFieldView);
		mxMenuTool->AddItem(mxMItemRandom);
	mxMBar->AddItem(mxMenuTool);
	xMenu = new BMenu(gxLLMsg->mxMenuHelp[mipHelp].String());
		xMItem = new BMenuItem(gxLLMsg->mxMenuHelp[miHelp].String(),new BMessage(MENUHELP_CLICKED),'H');
		xMItem->SetTarget(be_app);
		xMenu->AddItem(xMItem);
		xMenu->AddSeparatorItem();
		xMItem = new BMenuItem(gxLLMsg->mxMenuHelp[miAbout].String(),new BMessage(B_ABOUT_REQUESTED));
		xMItem->SetTarget(be_app);
		xMenu->AddItem(xMItem);
	mxMBar->AddItem(xMenu);
	ReflectSetting();
	mxPulseFilter = new TPulseFilter();
	AddCommonFilter(mxPulseFilter);
}
//------------------------------------------------------------------------------
TBeNaLifeWindow::~TBeNaLifeWindow()
{
	RemoveCommonFilter(mxPulseFilter);
	delete mxPulseFilter;
	gxExitState->mxFrame = Frame();
}
//------------------------------------------------------------------------------
void TBeNaLifeWindow::ChangeMBarState()
{
	ChangeMenuFileState();
	ChangeMenuEditState();
	ChangeMenuGeneState();
	ChangeMenuToolState();
}
//------------------------------------------------------------------------------
void TBeNaLifeWindow::ChangeMBarStateRqtd()
{
	if ( !mxMenuFile->IsHidden() )
		ChangeMenuFileState();
	if ( !mxMenuEdit->IsHidden() )
		ChangeMenuEditState();
	if ( !mxMenuGene->IsHidden() )
		ChangeMenuGeneState();
	if ( !mxMenuTool->IsHidden() )
		ChangeMenuToolState();
}
//------------------------------------------------------------------------------
void	TBeNaLifeWindow::ChangeMenuEditState()
{
	mxMItemCut->SetEnabled(!gxAppPrivacy->mbGoing);
	mxMItemCopy->SetEnabled(!gxAppPrivacy->mbGoing);
	mxMItemPaste->SetEnabled(!gxAppPrivacy->mbGoing && ClipHasData());
	mxMItemSelAll->SetEnabled(!gxAppPrivacy->mbGoing);
}
//------------------------------------------------------------------------------
void	TBeNaLifeWindow::ChangeMenuFileState()
{
	mxMItemNew->SetEnabled(!gxAppPrivacy->mbGoing);
	mxMItemOpen->SetEnabled(!gxAppPrivacy->mbGoing);
	mxMItemSave->SetEnabled(!gxAppPrivacy->mbGoing);
	mxMItemSaveAs->SetEnabled(!gxAppPrivacy->mbGoing);
}
//------------------------------------------------------------------------------
void	TBeNaLifeWindow::ChangeMenuGeneState()
{
	char	szTmp[EnblocMaxFig+20];
	
	mxMItemGo->SetEnabled(!gxAppPrivacy->mbGoing);
	mxMItemStop->SetEnabled(gxAppPrivacy->mbGoing);
	mxMItemStep->SetEnabled(!gxAppPrivacy->mbGoing);
	sprintf(szTmp,gxLLMsg->mxMItemEnbloc.String(),mxCtrlView->EnblocNum());
	mxMItemEnbloc->SetLabel(szTmp);
	mxMItemEnbloc->SetEnabled(!gxAppPrivacy->mbGoing);
}
//------------------------------------------------------------------------------
void	TBeNaLifeWindow::ChangeMenuToolState()
{
	mxMItemSetting->SetEnabled(!gxAppPrivacy->mbGoing);
	mxMItemRandom->SetEnabled(!gxAppPrivacy->mbGoing);
}
//------------------------------------------------------------------------------
TFieldView	*TBeNaLifeWindow::FieldView()
{
	return mxFieldView;
}
//------------------------------------------------------------------------------
void TBeNaLifeWindow::MenusBeginning()
{
	ChangeMBarState();
}
//------------------------------------------------------------------------------
void	TBeNaLifeWindow::MenuResizeToFitClicked()
{
	float	fHeight,fWidth;
	float	fX,fY;
	
	fWidth = CtrlViewWidth+gxCustomSet->miXBlocks*gxCustomSet->miXBlockSize
			+B_V_SCROLL_BAR_WIDTH;
	if ( fWidth > BScreen().Frame().right )
		fWidth = BScreen().Frame().right;
	fHeight = mxMBar->Frame().bottom+1+Max(mxCtrlView->OptimumHeight()
			,gxCustomSet->miYBlocks*gxCustomSet->miYBlockSize+B_H_SCROLL_BAR_HEIGHT);
	if ( fHeight > BScreen().Frame().bottom )	//VU:メニューバーの高さ
		fHeight = BScreen().Frame().bottom;
	ResizeTo(fWidth,fHeight);
	fX = Frame().left;
	fY = Frame().top;
	if ( Frame().right > BScreen().Frame().right )
		fX = BScreen().Frame().right-(Frame().right-Frame().left);
	if ( Frame().bottom > BScreen().Frame().bottom )
		fY = BScreen().Frame().bottom-(Frame().bottom-Frame().top);
	MoveTo(fX,fY);
}
//------------------------------------------------------------------------------
void	TBeNaLifeWindow::MenuSettingClicked()
{
	BMessage		*xMsg;
	TCustomSet		*xNewCustomSet;
	TSettingWindow	*xSetWin;
	
	xNewCustomSet = new TCustomSet();
	*xNewCustomSet = *gxCustomSet;
	xSetWin = new TSettingWindow(Frame(),xNewCustomSet);
	if ( xSetWin->Go() == IDOK ) {
		if ( xNewCustomSet->miXBlocks != gxCustomSet->miXBlocks
				|| xNewCustomSet->miYBlocks != gxCustomSet->miYBlocks ) {
			xMsg = new BMessage(DESTROYMAPARRAY_RQTD);
			be_app->DispatchMessage(xMsg,mxFieldView);
			delete xMsg;
			*gxCustomSet = *xNewCustomSet;
			xMsg = new BMessage(CREATEMAPARRAY_RQTD);
			be_app->DispatchMessage(xMsg,mxFieldView);
			delete xMsg;
		}
		else {
			*gxCustomSet = *xNewCustomSet;
		}
		ReflectSetting();
	}
	delete xNewCustomSet;
}
//------------------------------------------------------------------------------
void TBeNaLifeWindow::MessageReceived(BMessage *xMsg)
{
	switch( xMsg->what ) {
	case CHANGEMBARSTATE_RQTD:
		ChangeMBarStateRqtd();
		break;
	case MENURESIZETOFIT_CLICKED:
		MenuResizeToFitClicked();
		break;
	case MENUSETTING_CLICKED:
		MenuSettingClicked();
		break;
	default:
		BWindow::MessageReceived(xMsg);
	}
}
//------------------------------------------------------------------------------
bool TBeNaLifeWindow::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
}
//------------------------------------------------------------------------------
void	TBeNaLifeWindow::ReflectSetting()
{
	BMessage	*xMsg;
	
	xMsg = new BMessage(CHANGEVIEWCOL_RQTD);
	be_app->DispatchMessage(xMsg,mxCtrlView);
	delete xMsg;
	xMsg = new BMessage(REDRAWMAP_RQTD);
	be_app->DispatchMessage(xMsg,mxFieldView);
	delete xMsg;
}
//==============================================================================
TPulseFilter::TPulseFilter() : BMessageFilter(B_PULSE)
{
}
//------------------------------------------------------------------------------
filter_result	TPulseFilter::Filter(BMessage *xMsg, BHandler **xTgt)
{
	if ( Looper()->MessageQueue()->CountMessages() < 5 )
		return B_DISPATCH_MESSAGE;
	else
		return B_SKIP_MESSAGE;
}
//------------------------------------------------------------------------------
