/***************************************************************************

Donkey Kong and Donkey Kong Jr. memory map (preliminary) (DKong 3 follows)

0000-3fff ROM (Donkey Kong Jr.and Donkey Kong 3: 0000-5fff)
6000-6fff RAM
6900-6a7f sprites
7000-73ff ?
7400-77ff Video RAM
8000-9fff ROM (DK3 only)



memory mapped ports:

read:
7c00      IN0
7c80      IN1
7d00      IN2 (DK3: DSW2)
7d80      DSW1

*
 * IN0 (bits NOT inverted)
 * bit 7 : ?
 * bit 6 : reset (when player 1 active)
 * bit 5 : ?
 * bit 4 : JUMP player 1
 * bit 3 : DOWN player 1
 * bit 2 : UP player 1
 * bit 1 : LEFT player 1
 * bit 0 : RIGHT player 1
 *
*
 * IN1 (bits NOT inverted)
 * bit 7 : ?
 * bit 6 : reset (when player 2 active)
 * bit 5 : ?
 * bit 4 : JUMP player 2
 * bit 3 : DOWN player 2
 * bit 2 : UP player 2
 * bit 1 : LEFT player 2
 * bit 0 : RIGHT player 2
 *
*
 * IN2 (bits NOT inverted)
 * bit 7 : COIN
 * bit 6 : ?
 * bit 5 : ?
 * bit 4 : ?
 * bit 3 : START 2
 * bit 2 : START 1
 * bit 1 : ?
 * bit 0 : ? if this is 1, the code jumps to $4000, outside the rom space
 *
*
 * DSW1 (bits NOT inverted)
 * bit 7 : COCKTAIL or UPRIGHT cabinet (1 = UPRIGHT)
 * bit 6 : \ 000 = 1 coin 1 play   001 = 2 coins 1 play  010 = 1 coin 2 plays
 * bit 5 : | 011 = 3 coins 1 play  100 = 1 coin 3 plays  101 = 4 coins 1 play
 * bit 4 : / 110 = 1 coin 4 plays  111 = 5 coins 1 play
 * bit 3 : \bonus at
 * bit 2 : / 00 = 7000  01 = 10000  10 = 15000  11 = 20000
 * bit 1 : \ 00 = 3 lives  01 = 4 lives
 * bit 0 : / 10 = 5 lives  11 = 6 lives
 *

write:
7800-7803 ?
7808      ?
7c00      Background sound/music select:
          00 - nothing
		  01 - Intro tune
		  02 - How High? (intermisson) tune
		  03 - Out of time
		  04 - Hammer
		  05 - Rivet level 2 completed (end tune)
		  06 - Hammer hit
		  07 - Standard level end
		  08 - Background 1	(first screen)
		  09 - ???
		  0A - Background 3	(springs)
		  0B - Background 2 (rivet)
		  0C - Rivet level 1 completed (end tune)
		  0D - Rivet removed
		  0E - Rivet level completed
		  0F - Gorilla roar
7c80      gfx bank select (Donkey Kong Jr. only)
7d00      digital sound trigger - walk
7d01      digital sound trigger - jump
7d02      digital sound trigger - boom (gorilla stomps foot)
7d03      digital sound trigger - coin input/spring
7d04      digital sound trigger	- gorilla fall
7d05      digital sound trigger - barrel jump/prize
7d06      ?
7d07      ?
7d80      digital sound trigger - dead
7d82      ?
7d83      ?
7d84      interrupt enable
7d85      0/1 toggle
7d86-7d87 palette bank selector (only bit 0 is significant: 7d86 = bit 0 7d87 = bit 1)


Donkey Kong 3 memory map (preliminary):

RAM and read ports same as above;

write:
7d00      ?
7d80      ?
7e00      ?
7e80
7e81      char bank selector
7e82-7e83 ?
7e84      interrupt enable
7e85      ?
7e86-7e87 palette bank selector (only bit 0 is significant: 7e86 = bit 0 7e87 = bit 1)


I/O ports

write:
00        ?

*
 * IN0 (bits NOT inverted)
 * bit 7 : TEST
 * bit 6 : START 2
 * bit 5 : START 1
 * bit 4 : JUMP player 1
 * bit 3 : ? DOWN player 1 ?
 * bit 2 : ? UP player 1 ?
 * bit 1 : LEFT player 1
 * bit 0 : RIGHT player 1
 *
*
 * IN1 (bits NOT inverted)
 * bit 7 : ?
 * bit 6 : COIN 2
 * bit 5 : COIN 1
 * bit 4 : JUMP player 2
 * bit 3 : ? DOWN player 2 ?
 * bit 2 : ? UP player 2 ?
 * bit 1 : LEFT player 2
 * bit 0 : RIGHT player 2
 *
*
 * DSW1 (bits NOT inverted)
 * bit 7 : \ difficulty
 * bit 6 : / 00 = easy  01 = medium  10 = hard  11 = hardest
 * bit 5 : \ bonus
 * bit 4 : / 00 = 20000  01 = 30000  10 = 40000  11 = none
 * bit 3 : \ coins per play
 * bit 2 : /
 * bit 1 : \ 00 = 3 lives  01 = 4 lives
 * bit 0 : / 10 = 5 lives  11 = 6 lives
 *

***************************************************************************/

#include "driver.h"
#include "vidhrdw/generic.h"



void dkongjr_gfxbank_w(int offset,int data);
void dkong3_gfxbank_w(int offset,int data);
void dkong_palettebank_w(int offset,int data);
void dkong_vh_convert_color_prom(unsigned char *palette, unsigned char *colortable,const unsigned char *color_prom);
void dkong3_vh_convert_color_prom(unsigned char *palette, unsigned char *colortable,const unsigned char *color_prom);
int dkong_vh_start(void);
void dkong_vh_screenrefresh(struct osd_bitmap *bitmap);
void dkong3_vh_screenrefresh(struct osd_bitmap *bitmap);

void dkong_sh1_w(int offset,int data);
void dkong_sh2_w(int offset,int data);
void dkong_sh3_w(int offset,int data);
void dkong_sh_update(void);



static struct MemoryReadAddress readmem[] =
{
	{ 0x0000, 0x5fff, MRA_ROM },	/* DK: 0000-3fff */
	{ 0x6000, 0x6fff, MRA_RAM },	/* including sprites RAM */
	{ 0x7400, 0x77ff, MRA_RAM },	/* video RAM */
	{ 0x7c00, 0x7c00, input_port_0_r },	/* IN0 */
	{ 0x7c80, 0x7c80, input_port_1_r },	/* IN1 */
	{ 0x7d00, 0x7d00, input_port_2_r },	/* IN2/DSW2 */
	{ 0x7d80, 0x7d80, input_port_3_r },	/* DSW1 */
	{ 0x8000, 0x9fff, MRA_ROM },	/* DK3 and bootleg DKjr only */
	{ -1 }	/* end of table */
};

static struct MemoryWriteAddress dkong_writemem[] =
{
	{ 0x0000, 0x5fff, MWA_ROM },
	{ 0x6000, 0x68ff, MWA_RAM },
	{ 0x6900, 0x6a7f, MWA_RAM, &spriteram, &spriteram_size },
	{ 0x6a80, 0x6fff, MWA_RAM },
	{ 0x7400, 0x77ff, videoram_w, &videoram, &videoram_size },
	{ 0x7800, 0x7803, MWA_RAM },	/* ???? */
	{ 0x7808, 0x7808, MWA_RAM },	/* ???? */
	{ 0x7c00, 0x7c00, dkong_sh2_w },    	/* ???? */
	{ 0x7c80, 0x7c80, dkongjr_gfxbank_w },
	{ 0x7d00, 0x7d07, dkong_sh1_w },    /* ???? */
	{ 0x7d80, 0x7d80, dkong_sh3_w },
	{ 0x7d81, 0x7d83, MWA_RAM },	/* ???? */
	{ 0x7d84, 0x7d84, interrupt_enable_w },
	{ 0x7d85, 0x7d85, MWA_RAM },
	{ 0x7d86, 0x7d87, dkong_palettebank_w },
	{ -1 }	/* end of table */
};
static struct MemoryWriteAddress dkongjr_writemem[] =
{
	{ 0x0000, 0x5fff, MWA_ROM },
	{ 0x6000, 0x68ff, MWA_RAM },
	{ 0x6900, 0x6a7f, MWA_RAM, &spriteram, &spriteram_size },
	{ 0x6a80, 0x6fff, MWA_RAM },
	{ 0x7400, 0x77ff, videoram_w, &videoram, &videoram_size },
	{ 0x7800, 0x7803, MWA_RAM },	/* ???? */
	{ 0x7808, 0x7808, MWA_RAM },	/* ???? */
	{ 0x7c00, 0x7c00, MWA_RAM },	/* ???? */
	{ 0x7c80, 0x7c80, dkongjr_gfxbank_w },
	{ 0x7d00, 0x7d07, MWA_RAM },	/* ???? */
	{ 0x7d80, 0x7d83, MWA_RAM },	/* ???? */
	{ 0x7d84, 0x7d84, interrupt_enable_w },
	{ 0x7d85, 0x7d85, MWA_RAM },
	{ 0x7d86, 0x7d87, dkong_palettebank_w },
	{ 0x8000, 0x9fff, MWA_ROM },	/* bootleg DKjr only */
	{ -1 }	/* end of table */
};
static struct MemoryWriteAddress dkong3_writemem[] =
{
	{ 0x0000, 0x5fff, MWA_ROM },
	{ 0x6000, 0x68ff, MWA_RAM },
	{ 0x6900, 0x6a7f, MWA_RAM, &spriteram, &spriteram_size },
	{ 0x6a80, 0x6fff, MWA_RAM },
	{ 0x7400, 0x77ff, videoram_w, &videoram, &videoram_size },
	{ 0x7e81, 0x7e81, dkong3_gfxbank_w },
	{ 0x7e84, 0x7e84, interrupt_enable_w },
	{ 0x7e86, 0x7e87, dkong_palettebank_w },
	{ 0x8000, 0x9fff, MWA_ROM },
	{ -1 }	/* end of table */
};



static struct InputPort input_ports[] =
{
	{	/* IN0 */
		0x00,
		{ OSD_KEY_RIGHT, OSD_KEY_LEFT, OSD_KEY_UP, OSD_KEY_DOWN,
				OSD_KEY_LCONTROL, 0, 0, 0 },
		{ OSD_JOY_RIGHT, OSD_JOY_LEFT, OSD_JOY_UP, OSD_JOY_DOWN,
				OSD_JOY_FIRE, 0, 0, 0 },
	},
	{	/* IN1 */
		0x00,
		{ 0, 0, 0, 0, 0, 0, 0, 0 },
		{ 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{	/* IN2 */
		0x00,
		{ OSD_KEY_F2, 0, OSD_KEY_1, OSD_KEY_2, 0, 0, 0, OSD_KEY_3 },
		{ 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{	/* DSW1 */
		0x84,
		{ 0, 0, 0, 0, 0, 0, 0, 0 },
		{ 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ -1 }	/* end of table */
};

static struct InputPort dkong3_input_ports[] =
{
	{	/* IN0 */
		0x00,
		{ OSD_KEY_RIGHT, OSD_KEY_LEFT, OSD_KEY_UP, OSD_KEY_DOWN,
				OSD_KEY_LCONTROL, OSD_KEY_1, OSD_KEY_2, OSD_KEY_F1 },
		{ OSD_JOY_RIGHT, OSD_JOY_LEFT, OSD_JOY_UP, OSD_JOY_DOWN,
				OSD_JOY_FIRE, 0, 0, 0 },
	},
	{	/* IN1 */
		0x00,
		{ 0, 0, 0, 0, 0, OSD_KEY_3, 0, 0 },
		{ 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{	/* DSW2 */
		0x00,
		{ 0, 0, 0, 0, 0, 0, 0, 0 },
		{ 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{	/* DSW1 */
		0x00,
		{ 0, 0, 0, 0, 0, 0, 0, 0 },
		{ 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ -1 }	/* end of table */
};

static struct TrakPort trak_ports[] =
{
        { -1 }
};

static struct KEYSet keys[] =
{
        { 0, 2, "MOVE UP" },
        { 0, 1, "MOVE LEFT"  },
        { 0, 0, "MOVE RIGHT" },
        { 0, 3, "MOVE DOWN" },
        { 0, 4, "JUMP" },
        { -1 }
};


static struct DSW dsw[] =
{
	{ 3, 0x03, "LIVES", { "3", "4", "5", "6" } },
	{ 3, 0x0c, "BONUS", { "7000", "10000", "15000", "20000" } },
	{ -1 }
};

static struct DSW dkong3_dsw[] =
{
	{ 3, 0x03, "LIVES", { "3", "4", "5", "6" } },
	{ 3, 0x0c, "BONUS", { "30000", "40000", "50000", "NONE" } },
	{ 3, 0x30, "ADDITIONAL BONUS", { "30000", "40000", "50000", "NONE" } },
	{ 3, 0xc0, "DIFFICULTY", { "EASY", "MEDIUM", "HARD", "HARDEST" } },
	{ -1 }
};


static struct GfxLayout dkong_charlayout =
{
	8,8,	/* 8*8 characters */
	256,	/* 256 characters */
	2,	/* 2 bits per pixel */
	{ 256*8*8, 0 },	/* the two bitplanes are separated */
	{ 0, 1, 2, 3, 4, 5, 6, 7 },	/* pretty straightforward layout */
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8 },
	8*8	/* every char takes 8 consecutive bytes */
};
static struct GfxLayout dkongjr_charlayout =
{
	8,8,	/* 8*8 characters */
	512,	/* 512 characters */
	2,	/* 2 bits per pixel */
	{ 512*8*8, 0 },	/* the two bitplanes are separated */
	{ 0, 1, 2, 3, 4, 5, 6, 7 },	/* pretty straightforward layout */
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8 },
	8*8	/* every char takes 8 consecutive bytes */
};
static struct GfxLayout dkong_spritelayout =
{
	16,16,	/* 16*16 sprites */
	128,	/* 128 sprites */
	2,	/* 2 bits per pixel */
	{ 128*16*16, 0 },	/* the two bitplanes are separated */
	{ 0, 1, 2, 3, 4, 5, 6, 7,	/* the two halves of the sprite are separated */
			64*16*16+0, 64*16*16+1, 64*16*16+2, 64*16*16+3, 64*16*16+4, 64*16*16+5, 64*16*16+6, 64*16*16+7 },
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8,
			8*8, 9*8, 10*8, 11*8, 12*8, 13*8, 14*8, 15*8 },
	16*8	/* every sprite takes 16 consecutive bytes */
};
static struct GfxLayout dkong3_spritelayout =
{
	16,16,	/* 16*16 sprites */
	256,	/* 256 sprites */
	2,	/* 2 bits per pixel */
	{ 256*16*16, 0 },	/* the two bitplanes are separated */
	{ 0, 1, 2, 3, 4, 5, 6, 7,	/* the two halves of the sprite are separated */
			128*16*16+0, 128*16*16+1, 128*16*16+2, 128*16*16+3, 128*16*16+4, 128*16*16+5, 128*16*16+6, 128*16*16+7 },
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8,
			8*8, 9*8, 10*8, 11*8, 12*8, 13*8, 14*8, 15*8 },
	16*8	/* every sprite takes 16 consecutive bytes */
};



static struct GfxDecodeInfo dkong_gfxdecodeinfo[] =
{
	{ 1, 0x0000, &dkong_charlayout,   0, 64 },
	{ 1, 0x1000, &dkong_spritelayout, 0, 64 },
	{ -1 } /* end of array */
};
static struct GfxDecodeInfo dkongjr_gfxdecodeinfo[] =
{
	{ 1, 0x0000, &dkongjr_charlayout, 0, 64 },
	{ 1, 0x2000, &dkong_spritelayout, 0, 64 },
	{ -1 } /* end of array */
};
static struct GfxDecodeInfo dkong3_gfxdecodeinfo[] =
{
	{ 1, 0x0000, &dkongjr_charlayout,   0, 64 },
	{ 1, 0x2000, &dkong3_spritelayout,  0, 64 },
	{ -1 } /* end of array */
};



static unsigned char dkong_color_prom[] =
{
	/* 2k - palette low 4 bits (inverted) */
	0xFF,0xFC,0xF0,0xFF,0xFF,0xFB,0xFF,0xF0,0xFF,0xFA,0xFF,0xFD,0xFF,0xFC,0xFF,0xF3,
	0xFF,0xF3,0xFB,0xFF,0xFF,0xF0,0xFD,0xF3,0xFF,0xFF,0xFC,0xF0,0xFF,0xFF,0xFA,0xF0,
	0xFF,0xFF,0xFA,0xF3,0xFF,0xF0,0xF3,0xF5,0xFF,0xFD,0xF0,0xF5,0xFF,0xFC,0xF3,0xFA,
	0xFF,0xF0,0xF0,0xFC,0xFF,0xFF,0xFB,0xF3,0xFF,0xFE,0xFA,0xFC,0xFF,0xFB,0xFF,0xFF,
	0xFF,0xFC,0xF0,0xFF,0xFF,0xFB,0xFF,0xF0,0xFF,0xFA,0xFF,0xFD,0xFF,0xF3,0xFA,0xF0,
	0xFF,0xF3,0xFA,0xF0,0xFF,0xF3,0xFA,0xF0,0xFF,0xF3,0xFA,0xF0,0xFF,0xFF,0xFA,0xF0,
	0xFF,0xFF,0xFA,0xF3,0xFF,0xF0,0xF3,0xF5,0xFF,0xFD,0xF0,0xF5,0xFF,0xFC,0xF3,0xFA,
	0xFF,0xF0,0xF0,0xFC,0xFF,0xFF,0xFB,0xF3,0xFF,0xFE,0xFA,0xFC,0xFF,0xFB,0xFF,0xFF,
	0xFF,0xFC,0xF0,0xFF,0xFF,0xFB,0xFF,0xF0,0xFF,0xFA,0xFF,0xFD,0xFF,0xFA,0xFF,0xF0,
	0xFF,0xFA,0xFF,0xF0,0xFF,0xFA,0xFF,0xF0,0xFF,0xFA,0xFF,0xF0,0xFF,0xFF,0xFA,0xF0,
	0xFF,0xFF,0xFA,0xF3,0xFF,0xF0,0xF3,0xF5,0xFF,0xFD,0xF0,0xF5,0xFF,0xFC,0xF3,0xFA,
	0xFF,0xF0,0xF0,0xFC,0xFF,0xFF,0xFB,0xF3,0xFF,0xFE,0xFA,0xFC,0xFF,0xFB,0xFF,0xFF,
	0xFF,0xFC,0xF0,0xFF,0xFF,0xFB,0xFF,0xF0,0xFF,0xFA,0xFF,0xFD,0xFF,0xFC,0xF0,0xFB,
	0xFF,0xFC,0xF0,0xFB,0xFF,0xFC,0xF0,0xFB,0xFF,0xFC,0xF0,0xFB,0xFF,0xFF,0xFA,0xF0,
	0xFF,0xFF,0xFA,0xF3,0xFF,0xF0,0xF3,0xF5,0xFF,0xFD,0xF0,0xF5,0xFF,0xFC,0xF3,0xFA,
	0xFF,0xF0,0xF0,0xFC,0xFF,0xFF,0xFB,0xF3,0xFF,0xFE,0xFA,0xFC,0xFF,0xFB,0xFF,0xFF,
	/* 2j - palette high 4 bits (inverted) */
	0xFF,0xF6,0xFE,0xF1,0xFF,0xF0,0xF1,0xF0,0xFF,0xF0,0xF1,0xFF,0xFF,0xFF,0xF1,0xFE,
	0xFF,0xF1,0xF0,0xF1,0xFF,0xF0,0xF1,0xF0,0xFF,0xF1,0xFF,0xFE,0xFF,0xF5,0xF0,0xF0,
	0xFF,0xF5,0xF0,0xF1,0xFF,0xF0,0xF1,0xF1,0xFF,0xFF,0xF0,0xF1,0xFF,0xFF,0xF1,0xF0,
	0xFF,0xF0,0xFE,0xFF,0xFF,0xF1,0xF0,0xF1,0xFF,0xF2,0xF0,0xFF,0xFF,0xF0,0xF1,0xFF,
	0xFF,0xF6,0xFE,0xF1,0xFF,0xF0,0xF1,0xF0,0xFF,0xF0,0xF1,0xFF,0xFF,0xF1,0xF0,0xF0,
	0xFF,0xF1,0xF0,0xF0,0xFF,0xF1,0xF0,0xF0,0xFF,0xF1,0xF0,0xF0,0xFF,0xF5,0xF0,0xF0,
	0xFF,0xF5,0xF0,0xF1,0xFF,0xF0,0xF1,0xF1,0xFF,0xFF,0xF0,0xF1,0xFF,0xFF,0xF1,0xF0,
	0xFF,0xF0,0xFE,0xFF,0xFF,0xF1,0xF0,0xF1,0xFF,0xF2,0xF0,0xFF,0xFF,0xF0,0xF1,0xFF,
	0xFF,0xF6,0xFE,0xF1,0xFF,0xF0,0xF1,0xF0,0xFF,0xF0,0xF1,0xFF,0xFF,0xF1,0xF7,0xFE,
	0xFF,0xF1,0xF7,0xFE,0xFF,0xF1,0xF7,0xFE,0xFF,0xF1,0xF7,0xFE,0xFF,0xF5,0xF0,0xF0,
	0xFF,0xF5,0xF0,0xF1,0xFF,0xF0,0xF1,0xF1,0xFF,0xFF,0xF0,0xF1,0xFF,0xFF,0xF1,0xF0,
	0xFF,0xF0,0xFE,0xFF,0xFF,0xF1,0xF0,0xF1,0xFF,0xF2,0xF0,0xFF,0xFF,0xF0,0xF1,0xFF,
	0xFF,0xF6,0xFE,0xF1,0xFF,0xF0,0xF1,0xF0,0xFF,0xF0,0xF1,0xFF,0xFF,0xFF,0xFE,0xF0,
	0xFF,0xFF,0xFE,0xF0,0xFF,0xFF,0xFE,0xF0,0xFF,0xFF,0xFE,0xF0,0xFF,0xF5,0xF0,0xF0,
	0xFF,0xF5,0xF0,0xF1,0xFF,0xF0,0xF1,0xF1,0xFF,0xFF,0xF0,0xF1,0xFF,0xFF,0xF1,0xF0,
	0xFF,0xF0,0xFE,0xFF,0xFF,0xF1,0xF0,0xF1,0xFF,0xF2,0xF0,0xFF,0xFF,0xF0,0xF1,0xFF,
	/* 5f - character color codes on a per-column basis */
	0xF0,0xF1,0xF1,0xF2,0xF6,0xF6,0xF4,0xF6,0xF6,0xF6,0xF6,0xF3,0xF6,0xF3,0xF4,0xF3,
	0xF6,0xF6,0xF6,0xF6,0xF4,0xF3,0xF4,0xF5,0xF4,0xF6,0xF5,0xF3,0xF5,0xF3,0xF6,0xF3,
	0xF0,0xF1,0xF1,0xF2,0xF6,0xF6,0xF4,0xF6,0xF6,0xF6,0xF6,0xF3,0xF6,0xF3,0xF4,0xF3,
	0xF6,0xF6,0xF6,0xF6,0xF4,0xF3,0xF4,0xF5,0xF4,0xF6,0xF5,0xF3,0xF5,0xF3,0xF6,0xF3,
	0xF0,0xF1,0xF1,0xF2,0xF6,0xF6,0xF4,0xF6,0xF6,0xF6,0xF6,0xF3,0xF6,0xF3,0xF4,0xF3,
	0xF6,0xF6,0xF6,0xF6,0xF4,0xF3,0xF4,0xF5,0xF4,0xF6,0xF5,0xF3,0xF5,0xF3,0xF6,0xF3,
	0xF0,0xF1,0xF1,0xF2,0xF6,0xF6,0xF4,0xF6,0xF6,0xF6,0xF6,0xF3,0xF6,0xF3,0xF4,0xF3,
	0xF6,0xF6,0xF6,0xF6,0xF4,0xF3,0xF4,0xF5,0xF4,0xF6,0xF5,0xF3,0xF5,0xF3,0xF6,0xF3,
	0xF0,0xF1,0xF1,0xF2,0xF6,0xF6,0xF4,0xF6,0xF6,0xF6,0xF6,0xF3,0xF6,0xF3,0xF4,0xF3,
	0xF6,0xF6,0xF6,0xF6,0xF4,0xF3,0xF4,0xF5,0xF4,0xF6,0xF5,0xF3,0xF5,0xF3,0xF6,0xF3,
	0xF0,0xF1,0xF1,0xF2,0xF6,0xF6,0xF4,0xF6,0xF6,0xF6,0xF6,0xF3,0xF6,0xF3,0xF4,0xF3,
	0xF6,0xF6,0xF6,0xF6,0xF4,0xF3,0xF4,0xF5,0xF4,0xF6,0xF5,0xF3,0xF5,0xF3,0xF6,0xF3,
	0xF0,0xF1,0xF1,0xF2,0xF6,0xF6,0xF4,0xF6,0xF6,0xF6,0xF6,0xF3,0xF6,0xF3,0xF4,0xF3,
	0xF6,0xF6,0xF6,0xF6,0xF4,0xF3,0xF4,0xF5,0xF4,0xF6,0xF5,0xF3,0xF5,0xF3,0xF6,0xF3,
	0xF0,0xF1,0xF1,0xF2,0xF6,0xF6,0xF4,0xF6,0xF6,0xF6,0xF6,0xF3,0xF6,0xF3,0xF4,0xF3,
	0xF6,0xF6,0xF6,0xF6,0xF4,0xF3,0xF4,0xF5,0xF4,0xF6,0xF5,0xF3,0xF5,0xF3,0xF6,0xF3
};

static unsigned char dkongjr_color_prom[] =
{
	/* 2e - palette low 4 bits (inverted) */
	0x0F,0x0C,0x0A,0x0F,0x0F,0x00,0x0B,0x00,0x0F,0x0C,0x00,0x00,0x0F,0x0C,0x00,0x07,
	0x0F,0x0C,0x00,0x03,0x0F,0x0C,0x04,0x00,0x0F,0x0C,0x04,0x03,0x0F,0x07,0x00,0x0A,
	0x0F,0x0F,0x0C,0x09,0x0F,0x07,0x03,0x0A,0x0F,0x0E,0x0B,0x00,0x0F,0x03,0x0B,0x07,
	0x0F,0x0F,0x0B,0x00,0x0F,0x0C,0x07,0x00,0x0F,0x0F,0x07,0x00,0x0F,0x0C,0x07,0x00,
	0x0F,0x0C,0x0A,0x0F,0x0F,0x00,0x0B,0x00,0x0F,0x0F,0x03,0x05,0x0F,0x0F,0x03,0x05,
	0x0F,0x0F,0x03,0x05,0x0F,0x0F,0x03,0x05,0x0F,0x0F,0x00,0x05,0x0F,0x07,0x00,0x0A,
	0x0F,0x0F,0x0C,0x09,0x0F,0x07,0x03,0x0A,0x0F,0x0E,0x0B,0x00,0x0F,0x03,0x0B,0x07,
	0x0F,0x0F,0x0B,0x00,0x0F,0x0C,0x07,0x00,0x0F,0x0F,0x07,0x00,0x0F,0x0C,0x07,0x00,
	0x0F,0x0C,0x0A,0x0F,0x0F,0x0C,0x0B,0x00,0x0F,0x0C,0x04,0x0B,0x0F,0x0C,0x04,0x0B,
	0x0F,0x0C,0x04,0x0B,0x0F,0x0C,0x04,0x0B,0x0F,0x0C,0x04,0x0B,0x0F,0x07,0x00,0x0A,
	0x0F,0x0F,0x0C,0x09,0x0F,0x07,0x03,0x0A,0x0F,0x0E,0x0B,0x00,0x0F,0x03,0x0B,0x07,
	0x0F,0x0F,0x0B,0x00,0x0F,0x0C,0x07,0x00,0x0F,0x0F,0x07,0x00,0x0F,0x04,0x07,0x00,
	0x0F,0x0C,0x0A,0x0F,0x0F,0x00,0x0B,0x00,0x0F,0x04,0x00,0x00,0x0F,0x04,0x00,0x00,
	0x0F,0x04,0x00,0x00,0x0F,0x04,0x00,0x00,0x0F,0x04,0x00,0x00,0x0F,0x07,0x00,0x0A,
	0x0F,0x0F,0x0C,0x09,0x0F,0x07,0x03,0x0A,0x0F,0x0E,0x0B,0x00,0x0F,0x03,0x0B,0x07,
	0x0F,0x0F,0x0B,0x00,0x0F,0x0C,0x00,0x00,0x0F,0x0F,0x07,0x00,0x0F,0x0C,0x07,0x00,
	/* 2f - palette high 4 bits (inverted) */
	0x0F,0x0F,0x00,0x01,0x0F,0x09,0x00,0x00,0x0F,0x0F,0x00,0x09,0x0F,0x0F,0x00,0x01,
	0x0F,0x0F,0x00,0x00,0x0F,0x0F,0x0C,0x00,0x0F,0x0F,0x0C,0x0E,0x0F,0x05,0x00,0x00,
	0x0F,0x01,0x09,0x00,0x0F,0x05,0x01,0x00,0x0F,0x0F,0x00,0x00,0x0F,0x01,0x0E,0x00,
	0x0F,0x01,0x0E,0x00,0x0F,0x0F,0x00,0x00,0x0F,0x01,0x00,0x00,0x0F,0x01,0x00,0x00,
	0x0F,0x0F,0x00,0x01,0x0F,0x09,0x00,0x00,0x0F,0x00,0x0E,0x00,0x0F,0x00,0x0E,0x00,
	0x0F,0x00,0x0E,0x00,0x0F,0x00,0x0E,0x00,0x0F,0x00,0x0E,0x00,0x0F,0x05,0x00,0x00,
	0x0F,0x01,0x09,0x00,0x0F,0x05,0x01,0x00,0x0F,0x0F,0x00,0x00,0x0F,0x01,0x0E,0x00,
	0x0F,0x01,0x0E,0x00,0x0F,0x0F,0x00,0x00,0x0F,0x01,0x00,0x00,0x0F,0x01,0x00,0x00,
	0x0F,0x0F,0x00,0x01,0x0F,0x0F,0x00,0x00,0x0F,0x0F,0x0C,0x00,0x0F,0x0F,0x0C,0x00,
	0x0F,0x0F,0x0C,0x00,0x0F,0x0F,0x0C,0x00,0x0F,0x0F,0x0C,0x00,0x0F,0x05,0x00,0x00,
	0x0F,0x01,0x09,0x00,0x0F,0x05,0x01,0x00,0x0F,0x0F,0x00,0x00,0x0F,0x01,0x0E,0x00,
	0x0F,0x01,0x0E,0x00,0x0F,0x0F,0x00,0x00,0x0F,0x01,0x00,0x00,0x0F,0x07,0x00,0x00,
	0x0F,0x0F,0x00,0x01,0x0F,0x09,0x00,0x00,0x0F,0x01,0x00,0x09,0x0F,0x01,0x00,0x09,
	0x0F,0x01,0x00,0x09,0x0F,0x01,0x00,0x09,0x0F,0x01,0x00,0x09,0x0F,0x05,0x00,0x00,
	0x0F,0x01,0x09,0x00,0x0F,0x05,0x01,0x00,0x0F,0x0F,0x00,0x00,0x0F,0x01,0x0E,0x00,
	0x0F,0x01,0x0E,0x00,0x0F,0x0F,0x0E,0x00,0x0F,0x01,0x00,0x00,0x0F,0x01,0x00,0x00,
	/* 2n - character color codes on a per-column basis */
	0x00,0x01,0x07,0x01,0x01,0x01,0x03,0x02,0x04,0x05,0x04,0x05,0x02,0x05,0x02,0x05,
	0x03,0x03,0x02,0x03,0x03,0x04,0x03,0x04,0x04,0x05,0x04,0x05,0x05,0x05,0x05,0x06,
	0x00,0x01,0x07,0x01,0x01,0x01,0x03,0x02,0x04,0x05,0x04,0x05,0x02,0x05,0x02,0x05,
	0x03,0x03,0x02,0x03,0x03,0x04,0x03,0x04,0x04,0x05,0x04,0x05,0x05,0x05,0x05,0x06,
	0x00,0x01,0x07,0x01,0x01,0x01,0x03,0x02,0x04,0x05,0x04,0x05,0x02,0x05,0x02,0x05,
	0x03,0x03,0x02,0x03,0x03,0x04,0x03,0x04,0x04,0x05,0x04,0x05,0x05,0x05,0x05,0x06,
	0x00,0x01,0x07,0x02,0x02,0x02,0x03,0x02,0x04,0x05,0x04,0x05,0x02,0x05,0x02,0x05,
	0x03,0x03,0x02,0x03,0x03,0x04,0x03,0x04,0x04,0x05,0x04,0x05,0x05,0x05,0x05,0x06,
	0x00,0x01,0x07,0x02,0x02,0x02,0x03,0x02,0x04,0x05,0x04,0x05,0x02,0x05,0x02,0x05,
	0x03,0x03,0x02,0x03,0x03,0x04,0x03,0x04,0x04,0x05,0x04,0x05,0x05,0x05,0x05,0x06,
	0x00,0x01,0x07,0x02,0x02,0x02,0x03,0x02,0x04,0x05,0x04,0x05,0x02,0x05,0x02,0x05,
	0x03,0x03,0x02,0x03,0x03,0x04,0x03,0x04,0x04,0x05,0x04,0x05,0x05,0x05,0x05,0x06,
	0x00,0x01,0x07,0x02,0x02,0x02,0x03,0x02,0x04,0x05,0x04,0x05,0x02,0x05,0x02,0x05,
	0x03,0x03,0x02,0x03,0x03,0x04,0x03,0x04,0x04,0x05,0x04,0x05,0x05,0x05,0x05,0x06,
	0x00,0x01,0x07,0x02,0x02,0x02,0x03,0x02,0x04,0x05,0x04,0x05,0x02,0x05,0x02,0x05,
	0x03,0x03,0x02,0x03,0x03,0x04,0x03,0x04,0x04,0x05,0x04,0x05,0x05,0x05,0x05,0x06
};

static unsigned char dkong3_color_prom[] =
{
	/* 2fu - palette red component */
	0x00,0x0F,0x06,0x0F,0x00,0x00,0x0F,0x0F,0x00,0x08,0x0F,0x0F,0x00,0x08,0x08,0x08,
	0x00,0x08,0x0F,0x0E,0x00,0x00,0x00,0x0F,0x00,0x08,0x0F,0x08,0x00,0x0F,0x0F,0x00,
	0x00,0x06,0x0F,0x0F,0x00,0x04,0x01,0x0F,0x00,0x0F,0x0A,0x0F,0x00,0x0F,0x02,0x0F,
	0x00,0x00,0x00,0x0F,0x00,0x0F,0x0F,0x00,0x00,0x00,0x0F,0x0F,0x00,0x0F,0x06,0x0F,
	0x00,0x0F,0x06,0x0F,0x00,0x00,0x0F,0x0F,0x00,0x0C,0x0F,0x0F,0x00,0x0C,0x06,0x0D,
	0x00,0x0C,0x0B,0x01,0x00,0x00,0x00,0x0F,0x00,0x08,0x0F,0x08,0x00,0x0F,0x0F,0x00,
	0x00,0x06,0x0F,0x0F,0x00,0x04,0x01,0x0F,0x00,0x0F,0x0A,0x0F,0x00,0x0F,0x02,0x0F,
	0x00,0x00,0x00,0x0F,0x00,0x0F,0x0F,0x00,0x00,0x00,0x0F,0x0F,0x00,0x0F,0x06,0x0F,
	0x00,0x0F,0x06,0x0F,0x00,0x00,0x0F,0x0F,0x00,0x06,0x05,0x0F,0x00,0x0F,0x08,0x08,
	0x00,0x06,0x05,0x0F,0x00,0x00,0x00,0x0F,0x00,0x08,0x0F,0x08,0x00,0x0F,0x0F,0x00,
	0x00,0x06,0x0F,0x0F,0x00,0x04,0x01,0x0F,0x00,0x0F,0x0A,0x0F,0x00,0x0F,0x02,0x0F,
	0x00,0x00,0x00,0x0F,0x00,0x0F,0x0E,0x0F,0x00,0x00,0x0F,0x0F,0x00,0x0F,0x06,0x0F,
	0x00,0x0F,0x06,0x0F,0x00,0x00,0x0F,0x0F,0x00,0x0F,0x0F,0x0F,0x00,0x0F,0x0F,0x0F,
	0x00,0x0F,0x0F,0x0F,0x00,0x0F,0x0F,0x0F,0x00,0x08,0x0F,0x08,0x00,0x0F,0x0F,0x00,
	0x00,0x06,0x0F,0x0F,0x00,0x04,0x01,0x0F,0x00,0x0F,0x0A,0x0F,0x00,0x0F,0x02,0x0F,
	0x00,0x00,0x00,0x0F,0x00,0x0F,0x0F,0x00,0x00,0x00,0x0F,0x0F,0x00,0x0F,0x06,0x0F,
	/* 2e - palette green component */
	0x00,0x02,0x04,0x0F,0x00,0x02,0x08,0x0F,0x00,0x08,0x00,0x0F,0x00,0x08,0x0E,0x01,
	0x00,0x08,0x0F,0x08,0x00,0x00,0x00,0x0F,0x00,0x08,0x08,0x0A,0x00,0x00,0x06,0x00,
	0x00,0x00,0x02,0x0F,0x00,0x04,0x02,0x0F,0x00,0x00,0x00,0x03,0x00,0x0F,0x01,0x09,
	0x00,0x02,0x00,0x0F,0x00,0x0F,0x02,0x00,0x00,0x0F,0x00,0x0F,0x00,0x02,0x04,0x0C,
	0x00,0x02,0x04,0x0F,0x00,0x02,0x08,0x0F,0x00,0x0C,0x0E,0x0F,0x00,0x0C,0x00,0x00,
	0x00,0x0C,0x0B,0x02,0x00,0x00,0x00,0x0F,0x00,0x08,0x08,0x0A,0x00,0x00,0x06,0x00,
	0x00,0x00,0x02,0x0F,0x00,0x04,0x02,0x0F,0x00,0x00,0x00,0x03,0x00,0x0F,0x01,0x09,
	0x00,0x02,0x00,0x0F,0x00,0x0F,0x02,0x00,0x00,0x0F,0x00,0x0F,0x00,0x02,0x04,0x0C,
	0x00,0x02,0x04,0x0F,0x00,0x02,0x08,0x0F,0x00,0x0C,0x0D,0x0F,0x00,0x02,0x0E,0x01,
	0x00,0x0C,0x0D,0x0F,0x00,0x00,0x00,0x0F,0x00,0x08,0x08,0x0A,0x00,0x00,0x06,0x00,
	0x00,0x00,0x02,0x0F,0x00,0x04,0x02,0x0F,0x00,0x00,0x00,0x03,0x00,0x0F,0x01,0x09,
	0x00,0x02,0x00,0x0F,0x00,0x0F,0x0D,0x00,0x00,0x0F,0x00,0x0F,0x00,0x02,0x04,0x0C,
	0x00,0x02,0x04,0x0F,0x00,0x02,0x08,0x0F,0x00,0x00,0x0D,0x0F,0x00,0x00,0x0D,0x0F,
	0x00,0x00,0x0D,0x0F,0x00,0x00,0x0D,0x0F,0x00,0x08,0x08,0x0A,0x00,0x00,0x06,0x00,
	0x00,0x00,0x02,0x0F,0x00,0x04,0x02,0x0F,0x00,0x00,0x00,0x03,0x00,0x0F,0x01,0x09,
	0x00,0x02,0x00,0x0F,0x00,0x0F,0x02,0x00,0x00,0x0F,0x00,0x0F,0x00,0x02,0x04,0x0C,
	/* 2fl - palette blue component */
	0x00,0x05,0x00,0x0F,0x00,0x0F,0x03,0x0F,0x00,0x07,0x00,0x0F,0x00,0x07,0x03,0x03,
	0x00,0x07,0x0F,0x0F,0x00,0x09,0x04,0x0F,0x00,0x07,0x03,0x0F,0x00,0x00,0x00,0x06,
	0x00,0x00,0x03,0x0F,0x00,0x02,0x08,0x0F,0x00,0x00,0x00,0x00,0x00,0x0F,0x06,0x00,
	0x00,0x0F,0x05,0x0F,0x00,0x0F,0x00,0x0A,0x00,0x00,0x00,0x0F,0x00,0x05,0x00,0x02,
	0x00,0x05,0x00,0x0F,0x00,0x0F,0x03,0x0F,0x00,0x03,0x03,0x0F,0x00,0x03,0x00,0x00,
	0x00,0x03,0x0D,0x08,0x00,0x09,0x04,0x0F,0x00,0x07,0x03,0x0F,0x00,0x00,0x00,0x06,
	0x00,0x00,0x03,0x0F,0x00,0x02,0x08,0x0F,0x00,0x00,0x00,0x00,0x00,0x0F,0x06,0x00,
	0x00,0x0F,0x05,0x0F,0x00,0x0F,0x00,0x0A,0x00,0x00,0x00,0x0F,0x00,0x05,0x00,0x02,
	0x00,0x05,0x00,0x0F,0x00,0x0F,0x03,0x0F,0x00,0x00,0x00,0x04,0x00,0x00,0x03,0x03,
	0x00,0x00,0x00,0x04,0x00,0x09,0x04,0x0F,0x00,0x07,0x03,0x0F,0x00,0x00,0x00,0x06,
	0x00,0x00,0x03,0x0F,0x00,0x02,0x08,0x0F,0x00,0x00,0x00,0x00,0x00,0x0F,0x06,0x00,
	0x00,0x0F,0x05,0x0F,0x00,0x0F,0x07,0x00,0x00,0x00,0x00,0x0F,0x00,0x05,0x00,0x02,
	0x00,0x05,0x00,0x0F,0x00,0x0F,0x03,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,
	0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x07,0x03,0x0F,0x00,0x00,0x00,0x06,
	0x00,0x00,0x03,0x0F,0x00,0x02,0x08,0x0F,0x00,0x00,0x00,0x00,0x00,0x0F,0x06,0x00,
	0x00,0x0F,0x05,0x0F,0x00,0x0F,0x00,0x0A,0x00,0x00,0x00,0x0F,0x00,0x05,0x00,0x02,
	/* 2n - character color codes on a per-column basis */
	0x01,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
	0x03,0x03,0x03,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x05,0x05,
	0x01,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
	0x03,0x03,0x03,0x03,0x03,0x03,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x05,0x05,
	0x01,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x03,0x03,0x03,0x03,0x03,0x03,
	0x03,0x03,0x03,0x03,0x03,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x05,0x05,
	0x01,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
	0x02,0x02,0x02,0x02,0x02,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x05,0x05,
	0x01,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
	0x02,0x02,0x02,0x02,0x02,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x05,0x05,
	0x01,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x03,0x03,0x03,0x03,0x03,0x03,
	0x03,0x03,0x03,0x03,0x03,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x05,0x05,
	0x01,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
	0x03,0x03,0x03,0x03,0x03,0x03,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x05,0x05,
	0x01,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
	0x03,0x03,0x03,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x05,0x05
};

static unsigned char hunchy_color_prom[] =
{
	/* 2e - palette low 4 bits (inverted) */
	0x0F,0x0F,0x0A,0x03,0x0F,0x03,0x0C,0x00,0x0F,0x06,0x0A,0x0C,0x0F,0x0F,0x0E,0x03,
	0x0F,0x0C,0x03,0x0F,0x0F,0x00,0x00,0x0C,0x0F,0x0F,0x0A,0x03,0x0F,0x00,0x0F,0x00,
	0x0F,0x0C,0x0F,0x03,0x0F,0x0F,0x0C,0x06,0x0F,0x00,0x0F,0x0E,0x0F,0x0C,0x0F,0x03,
	0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,
	0x0F,0x0F,0x0A,0x0C,0x0F,0x03,0x0C,0x00,0x0F,0x06,0x0A,0x0C,0x0F,0x0F,0x0E,0x0C,
	0x0F,0x0C,0x03,0x0C,0x0F,0x00,0x00,0x0C,0x0F,0x0F,0x0A,0x0C,0x0F,0x00,0x0F,0x0C,
	0x0F,0x0C,0x0F,0x03,0x0F,0x0F,0x0C,0x06,0x0F,0x00,0x0F,0x0E,0x0F,0x0C,0x0F,0x03,
	0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,
	0x0F,0x0F,0x0A,0x03,0x0F,0x03,0x0C,0x00,0x0F,0x06,0x0A,0x03,0x0F,0x0F,0x0E,0x03,
	0x0F,0x0C,0x03,0x03,0x0F,0x00,0x00,0x03,0x0F,0x0F,0x0A,0x03,0x0F,0x00,0x0F,0x03,
	0x0F,0x0C,0x0F,0x03,0x0F,0x0F,0x0C,0x06,0x0F,0x00,0x0F,0x0E,0x0F,0x0C,0x0F,0x03,
	0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,
	0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,
	0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,
	0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,
	0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,
	/* 2f - palette high 4 bits (inverted) */
	0x0F,0x01,0x04,0x00,0x0F,0x0E,0x01,0x00,0x0F,0x00,0x03,0x01,0x0F,0x01,0x0F,0x0E,
	0x0F,0x0F,0x0E,0x01,0x0F,0x00,0x00,0x0F,0x0F,0x01,0x04,0x00,0x0F,0x00,0x01,0x0E,
	0x0F,0x01,0x01,0x0E,0x0F,0x01,0x01,0x00,0x0F,0x00,0x01,0x04,0x0F,0x01,0x01,0x0E,
	0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,
	0x0F,0x01,0x04,0x01,0x0F,0x0E,0x01,0x00,0x0F,0x00,0x03,0x01,0x0F,0x01,0x0F,0x01,
	0x0F,0x0F,0x0E,0x01,0x0F,0x00,0x00,0x01,0x0F,0x01,0x04,0x01,0x0F,0x00,0x01,0x01,
	0x0F,0x01,0x01,0x0E,0x0F,0x01,0x01,0x00,0x0F,0x00,0x01,0x04,0x0F,0x01,0x01,0x0E,
	0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,
	0x0F,0x01,0x04,0x0E,0x0F,0x0E,0x01,0x00,0x0F,0x00,0x03,0x0E,0x0F,0x01,0x0F,0x0E,
	0x0F,0x0F,0x0E,0x0E,0x0F,0x00,0x00,0x0E,0x0F,0x01,0x04,0x0E,0x0F,0x00,0x01,0x0E,
	0x0F,0x01,0x01,0x0E,0x0F,0x01,0x01,0x00,0x0F,0x00,0x01,0x04,0x0F,0x01,0x01,0x0E,
	0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,
	0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,
	0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,
	0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,
	0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,
	/* 2n - character color codes on a per-column basis */
	0x00,0x00,0x00,0x00,0x00,0x02,0x02,0x03,0x03,0x04,0x04,0x05,0x05,0x06,0x06,0x06,
	0x07,0x07,0x07,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
	0x00,0x00,0x00,0x00,0x00,0x02,0x02,0x03,0x03,0x04,0x04,0x05,0x05,0x06,0x06,0x06,
	0x07,0x07,0x07,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
	0x00,0x00,0x00,0x00,0x00,0x02,0x02,0x03,0x03,0x04,0x04,0x05,0x05,0x06,0x06,0x06,
	0x07,0x07,0x07,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
	0x00,0x00,0x00,0x00,0x00,0x02,0x02,0x03,0x03,0x04,0x04,0x05,0x05,0x06,0x06,0x06,
	0x07,0x07,0x07,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
	0x00,0x00,0x00,0x00,0x00,0x02,0x02,0x03,0x03,0x04,0x04,0x05,0x05,0x06,0x06,0x06,
	0x07,0x07,0x07,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
	0x00,0x00,0x00,0x00,0x00,0x02,0x02,0x03,0x03,0x04,0x04,0x05,0x05,0x06,0x06,0x06,
	0x07,0x07,0x07,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
	0x00,0x00,0x00,0x00,0x00,0x02,0x02,0x03,0x03,0x04,0x04,0x05,0x05,0x06,0x06,0x06,
	0x07,0x07,0x07,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
	0x00,0x00,0x00,0x00,0x00,0x02,0x02,0x03,0x03,0x04,0x04,0x05,0x05,0x06,0x06,0x06,
	0x07,0x07,0x07,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01
};



static struct MachineDriver dkong_machine_driver =
{
	/* basic machine hardware */
	{
		{
			CPU_Z80,
			3072000,	/* 3.072 Mhz (?) */
			0,
			readmem,dkong_writemem,0,0,
			nmi_interrupt,1
		}
	},
	60,
	10,	/* 10 CPU slices per frame - enough for the sound CPU to read all commands */
	0,

	/* video hardware */
	32*8, 32*8, { 0*8, 32*8-1, 2*8, 30*8-1 },
	dkong_gfxdecodeinfo,
	256, 64*4,
	dkong_vh_convert_color_prom,

	VIDEO_TYPE_RASTER|VIDEO_SUPPORTS_DIRTY,
	0,
	dkong_vh_start,
	generic_vh_stop,
	dkong_vh_screenrefresh,

	/* sound hardware */
	0,
	0,
	0,
	0,
	dkong_sh_update
};

static struct MachineDriver dkongjr_machine_driver =
{
	/* basic machine hardware */
	{
		{
			CPU_Z80,
			3072000,	/* 3.072 Mhz (?) */
			0,
			readmem,dkongjr_writemem,0,0,
			nmi_interrupt,1
		}
	},
	60,
	10,	/* 10 CPU slices per frame - enough for the sound CPU to read all commands */
	0,

	/* video hardware */
	32*8, 32*8, { 0*8, 32*8-1, 2*8, 30*8-1 },
	dkongjr_gfxdecodeinfo,
	256, 64*4,
	dkong_vh_convert_color_prom,

	VIDEO_TYPE_RASTER|VIDEO_SUPPORTS_DIRTY,
	0,
	dkong_vh_start,
	generic_vh_stop,
	dkong_vh_screenrefresh,

	/* sound hardware */
	0,
	0,
	0,
	0,
	0
};

static struct MachineDriver dkong3_machine_driver =
{
	/* basic machine hardware */
	{
		{
			CPU_Z80,
			4000000,	/* 4 Mhz ? */
			0,
			readmem,dkong3_writemem,0,0,
			nmi_interrupt,1
		}
	},
	60,
	10,	/* 10 CPU slices per frame - enough for the sound CPU to read all commands */
	0,

	/* video hardware */
	32*8, 32*8, { 0*8, 32*8-1, 2*8, 30*8-1 },
	dkong3_gfxdecodeinfo,
	256, 64*4,
	dkong3_vh_convert_color_prom,

	VIDEO_TYPE_RASTER|VIDEO_SUPPORTS_DIRTY,
	0,
	dkong_vh_start,
	generic_vh_stop,
	dkong_vh_screenrefresh,

	/* sound hardware */
	0,
	0,
	0,
	0,
	0
};



/***************************************************************************

  Game driver(s)

***************************************************************************/

ROM_START( dkong_rom )
	ROM_REGION(0x10000)	/* 64k for code */
	ROM_LOAD( "dk.5e",  0x0000, 0x1000, 0xa0bfe0f7 )
	ROM_LOAD( "dk.5c",  0x1000, 0x1000, 0x36320606 )
	ROM_LOAD( "dk.5b",  0x2000, 0x1000, 0x57b81038 )
	ROM_LOAD( "dk.5a",  0x3000, 0x1000, 0xe2f03e46 )
	/* space for diagnostic ROM */

	ROM_REGION(0x3000)	/* temporary space for graphics (disposed after conversion) */
	ROM_LOAD( "dk.3n",  0x0000, 0x0800, 0x5947fc8f )
	ROM_LOAD( "dk.3p",  0x0800, 0x0800, 0xcf971207 )
	ROM_LOAD( "dk.7c",  0x1000, 0x0800, 0xeca7e655 )
	ROM_LOAD( "dk.7d",  0x1800, 0x0800, 0xd8700f2a )
	ROM_LOAD( "dk.7e",  0x2000, 0x0800, 0x3dd5410b )
	ROM_LOAD( "dk.7f",  0x2800, 0x0800, 0xcc1d7c97 )

	ROM_REGION(0x1000)	/* sound */
	ROM_LOAD( "dk.3h",  0x0000, 0x0800, 0x52574a61 )
	ROM_LOAD( "dk.3f",  0x0800, 0x0800, 0x2a6cd3fa )
ROM_END

ROM_START( dkongjp_rom )
	ROM_REGION(0x10000)	/* 64k for code */
	ROM_LOAD( "5f.cpu",  0x0000, 0x1000, 0x949b12d3 )
	ROM_LOAD( "5g.cpu",  0x1000, 0x1000, 0xf81386e7 )
	ROM_LOAD( "5h.cpu",  0x2000, 0x1000, 0x45b7e62b )
	ROM_LOAD( "5k.cpu",  0x3000, 0x1000, 0x97dd25c5 )

	ROM_REGION(0x3000)	/* temporary space for graphics (disposed after conversion) */
	ROM_LOAD( "5h.vid",  0x0000, 0x0800, 0x5947fc8f )
	ROM_LOAD( "5k.vid",  0x0800, 0x0800, 0x8b237079 )
	ROM_LOAD( "4m.clk",  0x1000, 0x0800, 0xeca7e655 )
	ROM_LOAD( "4n.clk",  0x1800, 0x0800, 0xd8700f2a )
	ROM_LOAD( "4r.clk",  0x2000, 0x0800, 0x3dd5410b )
	ROM_LOAD( "4s.clk",  0x2800, 0x0800, 0xcc1d7c97 )

	ROM_REGION(0x1000)	/* sound */
	ROM_LOAD( "3i.sou",  0x0000, 0x0800, 0x52574a61 )
	ROM_LOAD( "3j.sou",  0x0800, 0x0800, 0x2a6cd3fa )
ROM_END

ROM_START( radarscp_rom )
	ROM_REGION(0x10000)	/* 64k for code */
	ROM_LOAD( "radar09",  0x0000, 0x1000, 0x00000000 )
	ROM_LOAD( "radar10",  0x1000, 0x1000, 0x00000000 )
	ROM_LOAD( "radar11",  0x2000, 0x1000, 0x00000000 )
	ROM_LOAD( "radar12",  0x3000, 0x1000, 0x00000000 )
	/* space for diagnostic ROM */

	ROM_REGION(0x3000)	/* temporary space for graphics (disposed after conversion) */
	ROM_LOAD( "radar08",  0x0000, 0x0800, 0x5d1336e3 )
	ROM_LOAD( "radar07",  0x0800, 0x0800, 0x1fbd16c3 )
	ROM_LOAD( "radar05",  0x1000, 0x0800, 0xa22a04e4 )
	ROM_LOAD( "radar04",  0x1800, 0x0800, 0x92fc90ae )
	ROM_LOAD( "radar03",  0x2000, 0x0800, 0x8689204f )
	ROM_LOAD( "radar02",  0x2800, 0x0800, 0x9a945dee )

	ROM_REGION(0x1000)	/* sound */
	ROM_LOAD( "radar01",  0x0000, 0x0800, 0x5eb1a017)	/* ??? */
	ROM_LOAD( "radar06",  0x0800, 0x0800, 0x681894a8)	/* ??? */
ROM_END

ROM_START( dkongjr_rom )
	ROM_REGION(0x10000)	/* 64k for code */
	ROM_LOAD( "dkj.5b",  0x0000, 0x1000, 0x831d73dd )
	ROM_CONTINUE(        0x3000, 0x1000 )
	ROM_LOAD( "dkj.5c",  0x2000, 0x0800, 0xe0078007 )
	ROM_CONTINUE(        0x4800, 0x0800 )
	ROM_CONTINUE(        0x1000, 0x0800 )
	ROM_CONTINUE(        0x5800, 0x0800 )
	ROM_LOAD( "dkj.5e",  0x4000, 0x0800, 0xb31be9f1 )
	ROM_CONTINUE(        0x2800, 0x0800 )
	ROM_CONTINUE(        0x5000, 0x0800 )
	ROM_CONTINUE(        0x1800, 0x0800 )

	ROM_REGION(0x4000)	/* temporary space for graphics (disposed after conversion) */
	ROM_LOAD( "dkj.3n",  0x0000, 0x1000, 0x4c96d5b0 )
	ROM_LOAD( "dkj.3p",  0x1000, 0x1000, 0xfbaafe4a )
	ROM_LOAD( "dkj.7c",  0x2000, 0x0800, 0x9ecd901b )
	ROM_LOAD( "dkj.7d",  0x2800, 0x0800, 0xac9378bb )
	ROM_LOAD( "dkj.7e",  0x3000, 0x0800, 0x9785a0b9 )
	ROM_LOAD( "dkj.7f",  0x3800, 0x0800, 0xecc39067 )

	ROM_REGION(0x1000)	/* sound? */
	ROM_LOAD( "dkj.3h",  0x0000, 0x1000, 0x65e71f9f )
ROM_END

ROM_START( dkjrjp_rom )
	ROM_REGION(0x10000)	/* 64k for code */
	ROM_LOAD( "dkj.5b",  0x0000, 0x1000, 0x558d63db )
	ROM_CONTINUE(        0x3000, 0x1000 )
	ROM_LOAD( "dkj.5c",  0x2000, 0x0800, 0xf8096601 )
	ROM_CONTINUE(        0x4800, 0x0800 )
	ROM_CONTINUE(        0x1000, 0x0800 )
	ROM_CONTINUE(        0x5800, 0x0800 )
	ROM_LOAD( "dkj.5e",  0x4000, 0x0800, 0xb319e9f7 )
	ROM_CONTINUE(        0x2800, 0x0800 )
	ROM_CONTINUE(        0x5000, 0x0800 )
	ROM_CONTINUE(        0x1800, 0x0800 )

	ROM_REGION(0x4000)	/* temporary space for graphics (disposed after conversion) */
	ROM_LOAD( "dkj.3n",  0x0000, 0x1000, 0x4c96d5b0 )
	ROM_LOAD( "dkj.3p",  0x1000, 0x1000, 0xfbaafe4a )
	ROM_LOAD( "dkj.7c",  0x2000, 0x0800, 0x9ecd901b )
	ROM_LOAD( "dkj.7d",  0x2800, 0x0800, 0xac9378bb )
	ROM_LOAD( "dkj.7e",  0x3000, 0x0800, 0x9785a0b9 )
	ROM_LOAD( "dkj.7f",  0x3800, 0x0800, 0xecc39067 )

	ROM_REGION(0x1000)	/* sound? */
	ROM_LOAD( "dkj.3h",  0x0000, 0x1000, 0x65e71f9f )
ROM_END

ROM_START( dkjrbl_rom )
	ROM_REGION(0x10000)	/* 64k for code */
	ROM_LOAD( "djr1-c.5b", 0x0000, 0x1000, 0xe453ca6f )
	ROM_CONTINUE(          0x3000, 0x1000 )
	ROM_LOAD( "djr1-c.5c", 0x2000, 0x0800, 0x22b438b8 )
	ROM_CONTINUE(          0x4800, 0x0800 )
	ROM_CONTINUE(          0x1000, 0x0800 )
	ROM_CONTINUE(          0x5800, 0x0800 )
	ROM_LOAD( "djr1-c.5e", 0x4000, 0x0800, 0x91018b3b )
	ROM_CONTINUE(          0x2800, 0x0800 )
	ROM_CONTINUE(          0x5000, 0x0800 )
	ROM_CONTINUE(          0x1800, 0x0800 )
	ROM_LOAD( "djr1-c.5a", 0x8000, 0x1000, 0x594ff833 )

	ROM_REGION(0x4000)	/* temporary space for graphics (disposed after conversion) */
	ROM_LOAD( "djr1-v.3n", 0x0000, 0x1000, 0x4c96d5b0 )
	ROM_LOAD( "djr1-v.3p", 0x1000, 0x1000, 0xfbaafe4a )
	ROM_LOAD( "djr1-v.7c", 0x2000, 0x0800, 0x9ecd901b )
	ROM_LOAD( "djr1-v.7d", 0x2800, 0x0800, 0xac9378bb )
	ROM_LOAD( "djr1-v.7e", 0x3000, 0x0800, 0x9785a0b9 )
	ROM_LOAD( "djr1-v.7f", 0x3800, 0x0800, 0xecc39067 )

	ROM_REGION(0x1000)	/* sound? */
	ROM_LOAD( "djr1-c.3h", 0x0000, 0x1000, 0x65e71f9f )
ROM_END

ROM_START( dkong3_rom )
	ROM_REGION(0x10000)	/* 64k for code */
	ROM_LOAD( "dk3c.7b", 0x0000, 0x2000, 0x1f48b2d8 )
	ROM_LOAD( "dk3c.7c", 0x2000, 0x2000, 0x02129a26 )
	ROM_LOAD( "dk3c.7d", 0x4000, 0x2000, 0xf6ac38f8 )
	ROM_LOAD( "dk3c.7e", 0x8000, 0x2000, 0x9aa51d95 )

	ROM_REGION(0x6000)	/* temporary space for graphics (disposed after conversion) */
	ROM_LOAD( "dk3v.3n", 0x0000, 0x1000, 0xce64f6d0 )
	ROM_LOAD( "dk3v.3p", 0x1000, 0x1000, 0x06537143 )
	ROM_LOAD( "dk3v.7c", 0x2000, 0x1000, 0xfdc2c044 )
	ROM_LOAD( "dk3v.7d", 0x3000, 0x1000, 0x79ed16db )
	ROM_LOAD( "dk3v.7e", 0x4000, 0x1000, 0x233a64e8 )
	ROM_LOAD( "dk3v.7f", 0x5000, 0x1000, 0x4381b33d )

	ROM_REGION(0x4000)	/* sound */
	ROM_LOAD( "dk3c.5l", 0x0000, 0x2000, 0x34813d8d )
	ROM_LOAD( "dk3c.6h", 0x2000, 0x2000, 0xe2c9caa7 )
ROM_END

ROM_START( hunchy_rom )
	ROM_REGION(0x10000)     /* 64k for code */
	/* the following is all wrong. Hunchback runs on a modified Donkey */
	/* Kong Jr. board, but with a twist. Here is how Tim Lindquist describes it: */
	/* Hunchback is a hack of a DKjr boardset. The only major difference that I */
	/* see is a new daughterboard in a CPU socket. It's got a big chip labeled  */
	/* MAB2650A CRG3243MOY. Perhap's that's a pin-scrambled 6502? */
	/* (2650/6502???... maybe a clue as to how its scrambled ;-) ). The db also */
	/* has various 74LS chips and a couple proms (soldered), and a VERY strange */
	/* looking flat chip. */
	ROM_LOAD( "1b.bin", 0x0000, 0x1000, 0xedc7328b )
	ROM_LOAD( "2a.bin", 0x1000, 0x1000, 0x07a951d3 )
	ROM_LOAD( "3a.bin", 0x2000, 0x1000, 0x84d6fc0e )
	ROM_LOAD( "4c.bin", 0x3000, 0x1000, 0xe2a39fbd )
	ROM_LOAD( "5a.bin", 0x4000, 0x1000, 0x2f46d302 )
	ROM_LOAD( "6c.bin", 0x5000, 0x1000, 0x8d6b2637 )
	ROM_LOAD( "8a.bin", 0x8000, 0x0800, 0x7afe3b86 )

	ROM_REGION(0x4000)      /* temporary space for graphics (disposed after conversion) */
	ROM_LOAD( "11a.bin", 0x0000, 0x0800, 0xf5280414 )
	ROM_LOAD( "9b.bin",  0x0800, 0x0800, 0x015ee94c )
	/* 1000-17ff empty */
	ROM_LOAD( "10b.bin", 0x1800, 0x0800, 0x72d82f86 )
	/* 2000-3fff empty */

	ROM_REGION(0x10000)     /* 64k for the audio CPU */
	ROM_LOAD( "5b_snd.bin", 0x0000, 0x0800, 0xd71b1c53 )
ROM_END



static const char *sample_names[] =
{
	"effect00.sam",
	"effect01.sam",
	"effect02.sam",
	"effect03.sam",
	"effect04.sam",
	"effect05.sam",
	"effect06.sam",
	"effect07.sam",
	"tune00.sam",
	"tune01.sam",
	"tune02.sam",
	"tune03.sam",
	"tune04.sam",
	"tune05.sam",
	"tune06.sam",
	"tune07.sam",
	"tune08.sam",
	"tune09.sam",
	"tune0a.sam",
	"tune0b.sam",
	"tune0c.sam",
	"tune0d.sam",
	"tune0e.sam",
	"tune0f.sam",
	"interupt.sam",
    0	/* end of array */
};



static int hiload(void)
{
	/* check if the hi score table has already been initialized */
	if (memcmp(&RAM[0x611d],"\x50\x76\x00",3) == 0 &&
			memcmp(&RAM[0x61a5],"\x00\x43\x00",3) == 0 &&
			memcmp(&RAM[0x60b8],"\x50\x76\x00",3) == 0)	/* high score */
	{
		void *f;


		if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_HIGHSCORE,0)) != 0)
		{
			osd_fread(f,&RAM[0x6100],34*5);
			RAM[0x60b8] = RAM[0x611d];
			RAM[0x60b9] = RAM[0x611e];
			RAM[0x60ba] = RAM[0x611f];
			/* also copy the high score to the screen, otherwise it won't be */
			/* updated until a new game is started */
			videoram_w(0x0221,RAM[0x6108]);
			videoram_w(0x0201,RAM[0x6109]);
			videoram_w(0x01e1,RAM[0x610a]);
			videoram_w(0x01c1,RAM[0x610b]);
			videoram_w(0x01a1,RAM[0x610c]);
			osd_fclose(f);
		}

		return 1;
	}
	else return 0;	/* we can't load the hi scores yet */
}



static void hisave(void)
{
	void *f;


	if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_HIGHSCORE,1)) != 0)
	{
		osd_fwrite(f,&RAM[0x6100],34*5);
		osd_fclose(f);
	}
}



static int dkong3_hiload(void)
{
	/* check if the hi score table has already been initialized */
	if (memcmp(&RAM[0x6b1d],"\x00\x20\x01",3) == 0 &&
			memcmp(&RAM[0x6ba5],"\x00\x32\x00",3) == 0)
	{
		void *f;


		if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_HIGHSCORE,0)) != 0)
		{
			osd_fread(f,&RAM[0x6b00],34*5);	/* hi scores */
			RAM[0x68f3] = RAM[0x6b1f];
			RAM[0x68f4] = RAM[0x6b1e];
			RAM[0x68f5] = RAM[0x6b1d];
			osd_fread(f,&RAM[0x6c20],0x40);	/* distributions */
			osd_fread(f,&RAM[0x6c16],4);
			osd_fclose(f);
		}

		return 1;
	}
	else return 0;	/* we can't load the hi scores yet */
}



static void dkong3_hisave(void)
{
	void *f;


	if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_HIGHSCORE,1)) != 0)
	{
		osd_fwrite(f,&RAM[0x6b00],34*5);	/* hi scores */
		osd_fwrite(f,&RAM[0x6c20],0x40);	/* distribution */
		osd_fwrite(f,&RAM[0x6c16],4);
		osd_fclose(f);
	}
}



struct GameDriver dkong_driver =
{
	"Donkey Kong (US version)",
	"dkong",
	"Gary Shepherdson (Kong emulator)\nBrad Thomas (hardware info)\nEdward Massey (MageX emulator)\nNicola Salmoria (MAME driver)\nRon Fries (sound)\nGary Walton (color info)\nSimon Walls (color info)",
	&dkong_machine_driver,

	dkong_rom,
	0, 0,
	sample_names,

	input_ports, 0, trak_ports, dsw, keys,

	dkong_color_prom, 0, 0,
	ORIENTATION_ROTATE_90,

	hiload, hisave
};

struct GameDriver dkongjp_driver =
{
	"Donkey Kong (Japanese version)",
	"dkongjp",
	"Gary Shepherdson (Kong emulator)\nBrad Thomas (hardware info)\nEdward Massey (MageX emulator)\nNicola Salmoria (MAME driver)\nRon Fries (sound)\nGary Walton (color info)\nSimon Walls (color info)",
	&dkong_machine_driver,

	dkongjp_rom,
	0, 0,
	sample_names,

	input_ports, 0, trak_ports, dsw, keys,

	dkong_color_prom, 0, 0,
	ORIENTATION_ROTATE_90,

	hiload, hisave
};

struct GameDriver radarscp_driver =
{
	"Radarscope",
	"radarscp",
	"Gary Shepherdson (Kong emulator)\nBrad Thomas (hardware info)\nEdward Massey (MageX emulator)\nNicola Salmoria (MAME driver)",
	&dkong_machine_driver,

	radarscp_rom,
	0, 0,
	0,

	input_ports, 0, trak_ports, dsw, keys,

	dkong_color_prom, 0, 0,
	ORIENTATION_ROTATE_90,

	0, 0
};

struct GameDriver dkongjr_driver =
{
	"Donkey Kong Jr. (US)",
	"dkongjr",
	"Gary Shepherdson (Kong emulator)\nBrad Thomas (hardware info)\nNicola Salmoria (MAME driver)\nTim Lindquist (color info)",
	&dkongjr_machine_driver,

	dkongjr_rom,
	0, 0,
	0,

	input_ports, 0, trak_ports, dsw, keys,

	dkongjr_color_prom, 0, 0,
	ORIENTATION_ROTATE_90,

	hiload, hisave
};

struct GameDriver dkjrjp_driver =
{
	"Donkey Kong Jr. (Japanese)",
	"dkjrjp",
	"Gary Shepherdson (Kong emulator)\nBrad Thomas (hardware info)\nNicola Salmoria (MAME driver)\nTim Lindquist (color info)",
	&dkongjr_machine_driver,

	dkjrjp_rom,
	0, 0,
	0,

	input_ports, 0, trak_ports, dsw, keys,

	dkongjr_color_prom, 0, 0,
	ORIENTATION_ROTATE_90,

	hiload, hisave
};

struct GameDriver dkjrbl_driver =
{
	"Donkey Kong Jr. (bootleg)",
	"dkjrbl",
	"Gary Shepherdson (Kong emulator)\nBrad Thomas (hardware info)\nNicola Salmoria (MAME driver)\nTim Lindquist (color info)",
	&dkongjr_machine_driver,

	dkjrbl_rom,
	0, 0,
	0,

	input_ports, 0, trak_ports, dsw, keys,

	dkongjr_color_prom, 0, 0,
	ORIENTATION_ROTATE_90,

	hiload, hisave
};

struct GameDriver dkong3_driver =
{
	"Donkey Kong 3",
	"dkong3",
	"Mirko Buffoni (MAME driver)\nNicola Salmoria (additional code)\nTim Lindquist (color info)",
	&dkong3_machine_driver,

	dkong3_rom,
	0, 0,
	0,

	dkong3_input_ports, 0, trak_ports, dkong3_dsw, keys,

	dkong3_color_prom, 0, 0,
	ORIENTATION_ROTATE_90,

	dkong3_hiload, dkong3_hisave
};

struct GameDriver hunchy_driver =
{
	"Hunchback",
	"hunchy",
	"Nicola Salmoria (MAME driver)\nTim Lindquist (color info)",
	&dkongjr_machine_driver,

	hunchy_rom,
	0, 0,
	0,

	input_ports, 0, trak_ports, dsw, keys,

	hunchy_color_prom, 0, 0,
	ORIENTATION_ROTATE_90,

	0, 0
};
