/*
	CMameDisplay.h
	The BeMAME Team
*/

#ifndef CMAMEDISPLAY_H
#define CMAMEDISPLAY_H

#include <SupportDefs.h>
#include <Rect.h>

class CMameView;

class CMameDisplay {
public:
	static void		CreateMameDisplay(
						status_t		*outRet,
						BRect			inFrame,
						int				inColorDepth,
						bool			inFullScreen);
					CMameDisplay();
	virtual			~CMameDisplay();

	virtual	void	ShutDown() = 0;

	virtual void	SetPenAtIdx(
						int32			inIdx,
						uint8			inRed,
						uint8			inGreen,
						uint8			inBlue) = 0;
	virtual void	SetPalette() = 0;
	virtual void	Update8BitDirect(
						uint8			*inSource,
						int32			inLineNumber,
						int32			inScreenWidth,
						int32			inVisibleWidth,
						bool			inDouble) = 0;
	virtual void	Update8BitDirectWScan(
						uint8			*inSource,
						int32			inLineNumber,
						int32			inScreenWidth,
						int32			inVisibleWidth) = 0;

	// view routines
	void			GetMouseDelta(
						int				*outDeltaX,
						int				*outDeltaY);
	static int		ReadKey(
						int				inKeycode);
						
protected:
	void			WaitToQuit();
	
	CMameView		*mView;
};

extern CMameDisplay		*gDisplay;

#endif
