//
// my_view.cc
//

#include <iostream.h>
#include "my_view.h"


my_view::my_view(BRect frame, const char *name, BLooper *win) :
	BTextView(frame, name, frame, B_FOLLOW_ALL, B_WILL_DRAW)
{
	parent_window = win;
	MakeEditable(false);
	MakeSelectable(false);
	SetWordWrap(false);
	MakeResizable(true);
}

void my_view::MessageReceived(BMessage *message)
{
	cout << "my_view::MessageReceived" << endl;
}


//
// Handle key events...
//
// When a key is pressed/released, put it in a message and send back to
//  the window thread.
//
void my_view::KeyDown(const char *bytes, int32 numBytes)
{
	if (numBytes == 1) {
		BMessage msg(MSG_KEY_PRESSED);
		msg.AddInt8("key", *bytes);
		parent_window->PostMessage(&msg, /*(BHandler *)*/ parent_window);
	}
}

void my_view::KeyUp(const char *bytes, int32 numBytes)
{
	if (numBytes == 1) {
		BMessage msg(MSG_KEY_RELEASED);
		msg.AddInt8("key", *bytes);
		parent_window->PostMessage(&msg, parent_window);
	}
}


