//Hammurabi
//Matt Wronkiewicz, 1997 10 12


#include "HamConsole.h"
#include "Hammurabi.h"
#include "BitmapView.h"
#include "Player.h"


enum
	{
	NEXT_TURN = 'hmNT',
	BUY = 'hmTB',
	SELL = 'hmTS',
	FEED = 'hmFD',
	PLANT = 'hmPT'
	};


HamConsole::HamConsole ()
	:BWindow(BRect(50, 50, 459, 272), "Hammurabi", B_TITLED_WINDOW, B_NOT_RESIZABLE, B_CURRENT_WORKSPACE)
	{
	player = new Player(this);
	
	BRect rect = Bounds();
	
	BMessage msg;
	((Hammurabi*)be_app)->GetResource("Babel Bitmap", &msg);
	BitmapView* background = new BitmapView(BBitmap::Instantiate(&msg), "");
	BRect extent = background->Bounds();
	
	rect.right = rect.left + extent.Width();
	rect.bottom = rect.top + extent.Height();
	
	rect.bottom += 20;
	ResizeTo(rect.right, rect.bottom);
	
	BView* base = new BView(Bounds(), B_EMPTY_STRING, B_FOLLOW_NONE, B_WILL_DRAW);
	base->SetViewColor(230, 230, 230);
	background->MoveBy(0, 20);
	base->AddChild(background);
	
	AddChild(base);
	
	BRect status_rect(0, 0, 192, 92);
	status_rect.OffsetTo(8, 262);
	BView* status_view = new BView(status_rect, B_EMPTY_STRING, B_FOLLOW_NONE, B_WILL_DRAW);
	status_view->SetViewColor(230, 230, 230);
	background->AddChild(status_view);
	
	BRect controls_rect(0, 0, 192, 150);
	controls_rect.OffsetTo(310, 262);
	BView* controls_view = new BView(controls_rect, B_EMPTY_STRING, B_FOLLOW_NONE, B_WILL_DRAW);
	controls_view->SetViewColor(230, 230, 230);
	background->AddChild(controls_view);
	
	BRect button_rect(0, 0, 64, 24);
	button_rect.OffsetTo(8, 388);
	BButton* next_turn = new BButton(button_rect, "next_turn", "Next Turn", new BMessage(NEXT_TURN));
	next_turn->MakeDefault(true);
	background->AddChild(next_turn);
	
	rect = base->Bounds();
	rect.right = rect.left + 64;
	rect.bottom = rect.top + 16;
	BStringView* year_label = new BStringView(rect, "year_label", "Year:");
	base->AddChild(year_label);
	rect.OffsetBy(64,0);
	year_control = new BStringView(rect, "year_control", "4000 BC");
	base->AddChild(year_control);
	
	rect.OffsetTo(2,0);
	BStringView* population_label = new BStringView(rect, "population_label", "Population:");
	status_view->AddChild(population_label);
	rect.OffsetBy(64,0);
	population_control = new BStringView(rect, "population_control", "100");
	status_view->AddChild(population_control);
	rect.OffsetBy(-64,24);
	BStringView* land_label = new BStringView(rect, "land_label", "Land:");
	status_view->AddChild(land_label);
	rect.OffsetBy(64,0);
	land_control = new BStringView(rect, "land_control", "1000");
	status_view->AddChild(land_control);
	rect.OffsetBy(64,0);
	BStringView* land_units = new BStringView(rect, "land_units", "acres");
	status_view->AddChild(land_units);
	rect.OffsetBy(-128,24);
	BStringView* storage_label = new BStringView(rect, "storage_label", "Storage:");
	status_view->AddChild(storage_label);
	rect.OffsetBy(64,0);
	storage_control = new BStringView(rect, "storage_control", "3000");
	status_view->AddChild(storage_control);
	rect.OffsetBy(64,0);
	BStringView* storage_units = new BStringView(rect, "storage_units", "bushels");
	status_view->AddChild(storage_units);
	rect.OffsetBy(-128,24);
	BStringView* market_label = new BStringView(rect, "market_label", "Land Price:");
	status_view->AddChild(market_label);
	rect.OffsetBy(64,0);
	market_control = new BStringView(rect, "market_control", "20");
	status_view->AddChild(market_control);
	rect.OffsetBy(64,0);
	BStringView* market_units = new BStringView(rect, "market_units", "bushels/acre");
	status_view->AddChild(market_units);
	
	rect.OffsetTo(2,0);
	rect.right = rect.left + 128;
	BStringView* trade_label = new BStringView(rect, "trade_label", "How many acres to trade?");
	controls_view->AddChild(trade_label);
	rect.OffsetBy(0,24);
	rect.right = rect.left + 56;
	trade_control = new BTextControl(rect, "trade_control", NULL, "0", NULL);
	controls_view->AddChild(trade_control);
	rect.OffsetBy(64,0);
	BButton* buy_button = new BButton(rect, "buy_button", "Buy", new BMessage(BUY));
	controls_view->AddChild(buy_button);
	rect.OffsetBy(64,0);
	BButton* sell_button = new BButton(rect, "sell_button", "Sell", new BMessage(SELL));
	controls_view->AddChild(sell_button);
	rect.OffsetBy(-128,24);
	rect.right = rect.left + 192;
	BStringView* feed_label = new BStringView(rect, "feed_label", "How much grain to give the people?");
	controls_view->AddChild(feed_label);
	rect.OffsetBy(0,24);
	rect.right = rect.left + 56;
	feed_control = new BTextControl(rect, "feed_control", NULL, "2000", NULL);
	controls_view->AddChild(feed_control);
	rect.OffsetBy(64,0);
	BButton* feed_button = new BButton(rect, "feed_button", "Distribute", new BMessage(FEED));
	controls_view->AddChild(feed_button);
	rect.OffsetBy(64,-13);
	feed_status = new BStatusBar(rect, "feed_status");
	rgb_color brown;
	brown.red = 140;
	brown.green = 140;
	brown.blue = 140;
	feed_status->SetBarColor(brown);
	controls_view->AddChild(feed_status);
	rect.OffsetBy(0,13);
	rect.OffsetBy(-128,24);
	rect.right = rect.left + 192;
	BStringView* plant_label = new BStringView(rect, "plant_label", "How many acres to plant?");
	controls_view->AddChild(plant_label);
	rect.OffsetBy(0,24);
	rect.right = rect.left + 56;
	plant_control = new BTextControl(rect, "plant_control", NULL, "1000", NULL);
	controls_view->AddChild(plant_control);
	rect.OffsetBy(64,0);
	BButton* plant_button = new BButton(rect, "plant_button", "Plant", new BMessage(PLANT));
	controls_view->AddChild(plant_button);
	rect.OffsetBy(64,-13);
	plant_status = new BStatusBar(rect, "plant_status");
	plant_status->SetBarColor(brown);
	controls_view->AddChild(plant_status);
	
	year = 4000;
	end_year = 3980;
	}


bool HamConsole::QuitRequested ()
	{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
	}


void HamConsole::setYear (int year)
	{
	Lock();
	if (year != atoi(year_control->Text()))
		{
		char year_string[8];
		sprintf(year_string, "%d BC", year);
		year_control->SetText(year_string);
		}
	Unlock();
	}


void HamConsole::setPopulation (int population)
	{
	Lock();
	if (population != atoi(population_control->Text()))
		{
		char string[10];
		sprintf(string, "%d", population);
		population_control->SetText(string);
		}
	Unlock();
	}


void HamConsole::setStorage (int storage)
	{
	Lock();
	if (storage != atoi(storage_control->Text()))
		{
		char string[10];
		sprintf(string, "%d", storage);
		storage_control->SetText(string);
		}
	Unlock();
	}


void HamConsole::setLand (int land)
	{
	Lock();
	if (land != atoi(land_control->Text()))
		{
		char string[10];
		sprintf(string, "%d", land);
		land_control->SetText(string);
		}
	Unlock();
	}


void HamConsole::setMarket (int land_price)
	{
	Lock();
	if (land_price != atoi(market_control->Text()))
		{
		char string[10];
		sprintf(string, "%d", land_price);
		market_control->SetText(string);
		}
	Unlock();
	}


void HamConsole::setFeed (int feed)
	{
	Lock();
	if (feed != atoi(feed_control->Text()))
		{
		char string[10];
		sprintf(string, "%d", feed);
		feed_control->SetText(string);
		}
	Unlock();
	}


int HamConsole::getFeed ()
	{
	return atoi(feed_control->Text());
	}


void HamConsole::setPlant (int acres)
	{
	Lock();
	if (acres != atoi(plant_control->Text()))
		{
		char string[10];
		sprintf(string, "%d", acres);
		plant_control->SetText(string);
		}
	Unlock();
	}


int HamConsole::getPlant ()
	{
	return atoi(plant_control->Text());
	}


void HamConsole::setTrade (int acres)
	{
	Lock();
	if (acres != atoi(trade_control->Text()))
		{
		char string[10];
		sprintf(string, "%d", acres);
		trade_control->SetText(string);
		}
	Unlock();
	}


int HamConsole::getTrade ()
	{
	return atoi(trade_control->Text());
	}


void HamConsole::MessageReceived(BMessage *msg)
	{
	switch(msg->what)
		{
		case NEXT_TURN:
			{
			year--;
			if (end_year > year)
				player->doEnd();
			else
				{
				if (player->isRebellion())
					player->doEnd();
				else
					{
					feed_status->Update(-feed_status->CurrentValue());
					plant_status->Update(-plant_status->CurrentValue());
					setYear(year);
					player->doRats();
					player->doGrow();
					player->doStats();
					}
				}
			break;
			}
		case BUY:
			{
			player->doBuy();
			break;
			}
		case SELL:
			{
			player->doSell();
			break;
			}
		case FEED:
			{
			player->doFeed();
			break;
			}
		case PLANT:
			{
			player->doPlant();
			break;
			}
		default:
			{
			inherited::MessageReceived(msg);
			break;
			}
		}
	}
